package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;


/**
 * 客户经营-经营计划模板
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
public class CrmOperationPlanTempQuery extends TwQueryParam {

    /**
     * 名字
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String name;

    /**
     * 类型 udc[crm:cust_oper:type]
     */
    @Query
    private String custType;

    /**
     * 客户级别 udc[crm:cust_oper:cust_grade]
     * 类型、客户级别 确定唯一
     * <p>
     * 特例：类型为 政府、组织及协会、生态伙伴的时候  客户级别为99 默认展示一级
     */
    @Query
    private String custGrade;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

    public CrmOperationPlanTempQuery() {
    }

    public CrmOperationPlanTempQuery(String custType, String custGrade) {
        this.custType = custType;
        this.custGrade = custGrade;
    }
    public CrmOperationPlanTempQuery(String custGrade) {
        this.custGrade = custGrade;
    }

}
