package com.elitesland.tw.tw5.api.prd.crm.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActProjectVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentDefaultVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;


/**
 * @author carl.wang
 * @Description:商机管理
 */
public interface CrmOpportunityService {

    /**
     * @param payload
     * @Description 新增活动
     **/
    CrmOpportunityVO insert(CrmOpportunityPayload payload);

    /**
     * @param payload
     * @Description 修改活动
     **/
    Long update(CrmOpportunityPayload payload);

    /**
     * 切换验证状态（待验证改为已验证，已验证改为待验证）
     *
     * @param ids
     */
    void toggleCheckStatus(List<Long> ids);

    /**
     * @param query
     * @return
     * @Description 分页查询
     **/
    PagingVO<CrmOpportunityVO> paging(CrmOpportunityQuery query);

    /**
     * @return
     * @Description 列表查询
     **/
    List<CrmOpportunityListVO> queryList();

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectVO}>
     */
    List<CrmOpportunityListVO> queryListDynamic(CrmOpportunityQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectVO}>
     */
    List<CrmOpportunityListVO> querySimpleList(CrmOpportunityQuery query);

    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    CrmOpportunityVO queryByKey(Long key);

    /**
     * @param key 主键简单查询
     * @return
     * @Description 主键查询
     **/
    CrmOpportunityVO queryByOppoProjId(Long key);

    /**
     * @param key 主键
     * @return boolean
     * @Description 修改状态
     **/
    boolean changeStatus(Long key);

    /**
     * @param key         主键
     * @param closeReson  关闭原因
     * @param loseReson   丢单原因
     * @param clsoeRemark 关闭备注
     * @return boolean
     * @Description 修改状态
     **/
    boolean closeOpportunity(Long key, String closeReson, String loseReson, String clsoeRemark, Boolean permissionFlag);

    /**
     * @param key     主键
     * @param userIds 用户ids
     * @return List<PrjProjectMemberVO>
     * @Description 新增成员
     **/
    List<PrjProjectMemberVO> addMember(Long key, List<Long> userIds);

    /**
     * @param keys   主键
     * @param oppoId 商机Id
     * @Description 删除成员
     **/
    boolean deleteMember(Long oppoId, List<Long> keys);

    /**
     * @param payload 跟进payload
     * @return
     * @Description 添加跟进动态
     **/
    void addFollow(CrmFollowPayload payload);

    /**
     * @param payload 跟进payload
     * @return
     * @Description 修改跟进动态
     **/
    void updateFollow(CrmFollowPayload payload);

    /**
     * @param objectId 商机id
     * @return
     * @Description 列表查询
     **/
    List<CrmFollowVO> queryListFollow(Long objectId);

    /**
     * 查询修改记录
     *
     * @param query 查询条件
     * @return
     */
    PagingVO<PrdSystemLogVO> queryLogList(PrdSystemLogQuery query);

    /**
     * 批量下载
     *
     * @param response
     * @param query
     */
    void downloadBatch(HttpServletResponse response, CrmOpportunityQuery query) throws IOException;

    /**
     * 批量下载-带权限
     *
     * @param response
     * @param query
     */
    void permissionBatchExport(HttpServletResponse response, CrmOpportunityQuery query) throws IOException;


    /**
     * 关联客户
     *
     * @param id
     */
    Map<String, Object> bindCustomer(Long id);

    /**
     * 为商机绑定客户
     *
     * @return
     */
    Map<String, Object> bindCustomers();

    Long getIdByV4(Long oppoIdV4);


    // /**
    //  * 获取易稻壳文件夹地址
    //  * 1、文件夹不存在，创建、授权、返回itemId 存到商机数据中；获取易稻壳链接；
    //  * 2、itemId存在，根据itemId查询易稻壳链接返回；
    //  *
    //  * @return result
    //  */
    // String yeedocGetUri(Long id);

    void deleteSoft(Long id);

    Map<Long, Long> getV4AndV5OppoIds();

    /**
     * 校验商机的案情分析、竞争对手、商机干系人和关键里程碑计划
     *
     * @return
     */
    Boolean checkIntegrity(Long oppoId);

    /**
     * 统计个数
     *
     * @param query 查询
     * @return long
     */
    long count(CrmOpportunityQuery query);

    /**
     * 根据客户id获取商机名称
     *
     * @param customId
     * @return
     */
    List<CrmActProjectVO> queryListByCustomId(Long customId);

    /**
     * 计算商机成单概率
     *
     * @param key
     * @return
     */
    Map<String, String> caculateProbability(Long key);

    PagingVO<CrmOpportunityVO> permissionPaging(CrmOpportunityQuery query);


    /**
     * 通过商机编号查询付款申请单前置数据
     *
     * @param docNo 商机编号
     * @return 付款申请单前置数据
     */
    PurchasePaymentDefaultVO findPaymentDefaultByDocNo(String docNo);

    /**
     * 查询当前用户所在签约BU商机
     *
     * @return 商机列表
     */
    List<CrmOpportunityVO> selectOpportunityListByUserBu();

    /**
     * 根据商机编号查询签约Bu
     *
     * @param docNo 商机编号
     * @return签约Bu
     */
    Long findOrgIdByDocNo(String docNo);

}

