package com.elitesland.tw.tw5.api.prd.org.vo;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;


@SearchBean(
        tables = "prd_org_person person " +
                "left join prd_org_employee employee on employee.person_id = person.id ",
        where = "person.delete_flag = 0 and (person.in_black_list=0 or person.in_black_list is null) and employee.resource_status in ('1','2','6')",
        autoMapTo = "person"
)
@Data
public class PrdOrgPersonBSVO extends BaseViewModel {

    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag = 0;

    @ApiModelProperty("姓名")
    private String personName;

    @ApiModelProperty("审批状态")
    private String apprStatus;

    @UdcName(udcName = "appr_status", codePropName = "apprStatus")
    @DbIgnore
    private String apprStatusName;

    @ApiModelProperty("性别")
    private String sex;

    @ApiModelProperty("用户账号")
    private String userName;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "用户邮箱地址")
    private String email;

    @ApiModelProperty("外文名")
    private String foreignName;

    @ApiModelProperty("证件类型")
    private String idType;

    @ApiModelProperty("证件号码")
    private String idNo;

    @ApiModelProperty("证件开始日")
    private LocalDate idValidFrom;

    @ApiModelProperty("证件到期日")
    private LocalDate idValidTo;

    @ApiModelProperty("证件url")
    private String idValidCodes;

    @DbIgnore
    private Object idValidDatas;

    @ApiModelProperty("头像url")
    private String headCodes;

    @DbIgnore
    @ApiModelProperty("headDatas")
    private Object headDatas;

    @ApiModelProperty("生日")
    private LocalDate birthday;

    @ApiModelProperty("国籍")
    private String nationality;

    @ApiModelProperty("籍贯")
    private String birthplace;

    @ApiModelProperty("民族")
    private String nation;

    @ApiModelProperty("婚姻状况")
    private Integer marital;

    @ApiModelProperty("通讯地址")
    private String addr;

    @ApiModelProperty("紧急联系人")
    private String urgency_name;

    @ApiModelProperty("手机号")
    private String urgency_mobile;

    @ApiModelProperty("关系")
    private String urgency_ref;

    @ApiModelProperty("排序")
    private Integer sortIndex;

    @ApiModelProperty("自我评价")
    private String selfEvaluation;

    @ApiModelProperty("个人简历url")
    private String resumeCodes;

    @ApiModelProperty("resumeDatas")
    @DbIgnore
    private Object resumeDatas;

    @ApiModelProperty("自我介绍视频url")
    private String selfIntroVideoCodes;

    @ApiModelProperty("selfIntroVideoDatas")
    @DbIgnore
    private Object selfIntroVideoDatas;

    @ApiModelProperty("标签")
    private String selfTagging;

    @ApiModelProperty("专业技能&专业领域")
    private String professionalSkills;

    @ApiModelProperty("从业年限")
    private String professionalYears;

//    public String getApprStatusDesc() {
//        if (null == apprStatus) {
//            return "";
//        }
//        return apprStatus.getDesc();
//    }

    @ApiModelProperty("人才状态")
    @DbField("employee.resource_status")
    private String resourceStatus;
    @UdcName(udcName = "org:employee:resource", codePropName = "resourceStatus")
    @DbIgnore
    private String resourceStatusName;

    @ApiModelProperty("员工id")
    @DbField("employee.id")
    private Long employeeId;

    @ApiModelProperty("离职日期")
    @DbField("employee.ext_date1")
    private LocalDate extDate1;
}
