package com.elitesland.tw.tw5.api.prd.partner.identity.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCollaboratePartnerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCollaboratePartnerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCollaboratePartnerInfoVO;

import java.util.List;

/**
 * 业务伙伴-合作伙伴
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BusinessCollaboratePartnerInfoService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessCollaboratePartnerInfoVO}>
     */
    PagingVO<BusinessCollaboratePartnerInfoVO> queryPaging(BusinessCollaboratePartnerInfoQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessCollaboratePartnerInfoVO}>
     */
    List<BusinessCollaboratePartnerInfoVO> queryListDynamic(BusinessCollaboratePartnerInfoQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessCollaboratePartnerInfoVO}
     */
    BusinessCollaboratePartnerInfoVO queryByKey(Long key);

    /**
     * 通过业务伙伴主键查询
     *
     * @param partnerId 业务伙伴主键
     * @return {@link BusinessCollaboratePartnerInfoVO}
     */
    BusinessCollaboratePartnerInfoVO queryByPartnerId(Long partnerId);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessCollaboratePartnerInfoVO}
     */
    BusinessCollaboratePartnerInfoVO insert(BusinessCollaboratePartnerInfoPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessCollaboratePartnerInfoVO}
     */
    BusinessCollaboratePartnerInfoVO update(BusinessCollaboratePartnerInfoPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 合作伙伴激活
     *
     */
    void  activeCollaboratePartner(Long partnerId,String partnerName);

    /**
     * 更新合作伙伴的团队成员
     *
     */
    void updateCollaborateTeamMember(BusinessCollaboratePartnerInfoPayload payload);
}
