package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitesland.tw.tw5.api.prd.purchase.payload.BillVerDetailPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.BillVerDetailQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.BillVerDetailVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * 预付款收据管理
 *
 * @author wangly
 * @date 2024-05-27
 */
public interface BillVerDetailService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BillVerDetailVO}>
     */
    PagingVO<BillVerDetailVO> queryPaging(BillVerDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BillVerDetailVO}>
     */
    List<BillVerDetailVO> queryListDynamic(BillVerDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BillVerDetailVO}
     */
    BillVerDetailVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BillVerDetailVO}
     */
    BillVerDetailVO insert(BillVerDetailPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BillVerDetailVO}
     */
    BillVerDetailVO update(BillVerDetailPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BillVerDetailPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据付款申请单id查询票据核销明细列表
     * @param docType 类型 合同OR协议
     * @param paymentApplyId 付款申请单id
     */
    List<BillVerDetailVO> queryListByPaymentApplyId(String docType, Long paymentApplyId);


    List<BillVerDetailVO> queryListIsNullByPaymentApplyId(String docType, Long paymentApplyId);

    /**
     * 根据付款申请单id删除票据核销明细
     * @param paymentApplyId 付款申请单id
     */
    void deleteByPaymentApplyId(Long paymentApplyId);

    /**
     * 批量新增票据核销明细
     * @param billVerDetailPayloads 票据核销明细
     */
    void insertAll(List<BillVerDetailPayload> billVerDetailPayloads);

}
