package com.elitesland.tw.tw5.api.prd.purchase.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 费用承担部门
 *
 * @author likunpeng
 * @date 2023-11-07
 */
@Getter
@Setter
public class CostUndertakeDepartmentVO extends BaseViewModel implements Serializable {
    /**
     * 付款申请单id
     */
    @ApiModelProperty("付款申请单id")
    private Long paymentApplyId;

    /**
     * 费用承担BU_ID
     */
    @ApiModelProperty("费用承担BU_ID")
    private Long bearBuId;

    /**
     * 费用承担BU_Name
     */
    @ApiModelProperty("费用承担BU_Name")
    @UdcName(udcName = "BU", codePropName = "bearBuId")
    private String bearBuName;

    /**
     * 费用承担金额
     */
    @ApiModelProperty("费用承担金额")
    private BigDecimal bearAmt;

    /**
     * 科目说明(pms_acc_mas表id)
     */
    @ApiModelProperty("科目说明(pms_acc_mas表id)")
    private Long accMasId;

    /**
     * 科目说明Desc
     */
    @ApiModelProperty("科目说明Desc")
    private String accMasName;

    /**
     * JDE回传标记
     */
    @ApiModelProperty("JDE回传标记 0:为传 1:已回传")
    private Integer jdeFlag;

    /**
     * 发票号
     */
    @ApiModelProperty("发票号")
    private String invoiceNo;

}
