package com.elitesland.tw.tw5.api.prd.salecon.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * 销售合同
 *
 * @author danting
 * @date 2023-03-30
 */
@Getter
@Setter
public class SaleConContractQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    @Query
    private Long id;

    /**
     * 记录唯一ID集合 精确
     */
    @ApiModelProperty("记录唯一ID集合")
    @Query
    private List<Long> ids;

    /**
     * 合同编号 模糊
     */
    @ApiModelProperty("合同编号")
    @Query(type = Query.Type.INNER_LIKE)
    private String code;
    /**
     * 合同名称 模糊
     */
    @ApiModelProperty("合同名称")
    @Query(type = Query.Type.INNER_LIKE)
    private String name;

    @ApiModelProperty("合同名称（完全相等）")
    private String eqName;
    /**
     * 合同状态 精确
     */
    @ApiModelProperty("合同状态")
    @Query
    private String status;
    /**
     * 合同状态 第一个为：0：=，1：!=，第二个为合同状态
     */
    @Query
    private List<String> statusList = new ArrayList<>();
//    /**
//     * 签约公司ID 精确
//     */
//    @ApiModelProperty("签约公司ID")
//    @Query
//    private Long ouId;

    @ApiModelProperty("签约公司ID")
    @Query
    private Long ouBookId;
    /**
     * 参考合同号 精确
     */
    @ApiModelProperty("参考合同号")
    @Query
    private String referCode;
    /**
     * 商机ID 精确
     */
    @ApiModelProperty("商机ID")
    @Query
    private Long oppoId;
    @ApiModelProperty("商机IDs")
    @Query
    private List<Long> oppoIds;
    /**
     * 客户ID 精确
     */
    @ApiModelProperty("客户ID")
    @Query
    private Long custId;


    /**
     * 客户ID List 精确
     */
    @ApiModelProperty("客户ID集合")
    @Query
    private List<Long> custIdList;
    /**
     * 签约时客户名称 精确
     */
    @ApiModelProperty("签约时客户名称")
    @Query
    private String custName;
    /**
     * 关联合同ID 精确
     */
    @ApiModelProperty("关联合同ID")
    @Query
    private Long relatedContractId;
    /**
     * 新客户标志，0：新客户，1：老客户 精确
     */
    @ApiModelProperty("新客户标志，0：新客户，1：老客户")
    @Query
    private Long custFlag;
    /**
     * 签订日期 精确
     */
    @ApiModelProperty("签订日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Query
    private LocalDate signDate;
    /**
     * 特别关注点 精确
     */
    @ApiModelProperty("特别关注点")
    @Query
    private String specialConcerned;
    /**
     * 币种 精确
     */
    @ApiModelProperty("币种")
    @Query
    private String currCode;
    /**
     * 关闭原因 精确
     */
    @ApiModelProperty("关闭原因")
    @Query
    private String closeReason;
    /**
     * 关闭时间
     */
    @ApiModelProperty("关闭时间")
    @Query
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate closeDate;
    /**
     * 客户项目 精确
     */
    @ApiModelProperty("客户项目")
    @Query
    private String custProj;
    /**
     * 销售内容 精确
     */
    @ApiModelProperty("销售内容")
    @Query
    private String saleContent;
    /**
     * 产品大类 精确
     */
    @ApiModelProperty("产品大类")
    @Query
    private String productClass;
    /**
     * 产品小类 精确
     */
    @ApiModelProperty("产品小类")
    @Query
    private String productSubClass;
    /**
     * 交付地点 精确
     */
    @ApiModelProperty("交付地点")
    @Query
    private String deliveryAddress;
    /**
     * 财务期间ID 精确
     */
    @ApiModelProperty("财务期间ID")
    @Query
    private Long finPeriodId;
    /**
     * 合同总金额 精确
     */
    @ApiModelProperty("合同总金额")
    @Query
    private BigDecimal amt;
    /**
     * 其它费用 精确
     */
    @ApiModelProperty("其它费用")
    @Query
    private BigDecimal extraAmt;
    /**
     * 有效合同金额 精确
     */
    @ApiModelProperty("有效合同金额")
    @Query
    private BigDecimal effectiveAmt;
    /**
     * 毛利 精确
     */
    @ApiModelProperty("毛利")
    @Query
    private BigDecimal grossProfit;
    /**
     * 销售区域BU_ID 精确
     */
    @ApiModelProperty("销售区域BU_ID")
    @Query
    private Long regionBuId;
    /**
     * 销售区域负责人 精确
     */
    @ApiModelProperty("销售区域负责人")
    @Query
    private Long regionUserId;
    /**
     * 签单BU_ID 精确
     */
    @ApiModelProperty("签单BU_ID")
    @Query
    private Long signBuId;
    /**
     * 销售人员资源ID 精确
     */
    @ApiModelProperty("销售人员资源ID")
    @Query
    private Long salesmanResId;
    /**
     * 副签单BU_ID 精确
     */
    @ApiModelProperty("副签单BU_ID")
    @Query
    private Long coSignBuId;
    /**
     * 副签单用户id 精确
     */
    @ApiModelProperty("副签单用户id")
    @Query
    private Long coSignUserId;
    /**
     * 交付BU_ID 精确
     */
    @ApiModelProperty("交付BU_ID")
    @Query
    private Long deliBuId;
    /**
     * 交付用户id 精确
     */
    @ApiModelProperty("交付用户id")
    @Query
    private Long deliUserId;
    /**
     * 副交付BU_ID 精确
     */
    @ApiModelProperty("副交付BU_ID")
    @Query
    private Long codeliBuId;
    /**
     * 副交付用户id 精确
     */
    @ApiModelProperty("副交付用户id")
    @Query
    private Long codeliUserId;
    /**
     * 平台合同类型 精确
     */
    @ApiModelProperty("平台合同类型")
    @Query
    private String platType;
    /**
     * 主合同类型 精确
     */
    @ApiModelProperty("主合同类型")
    @Query
    private String mainType;
    /**
     * PMO用户ID 精确
     */
    @ApiModelProperty("PMO用户ID")
    @Query
    private Long pmoUserId;
    /**
     * 来源类型 精确
     */
    @ApiModelProperty("来源类型")
    @Query
    private String sourceType;
    /**
     * 外部来源 精确
     */
    @ApiModelProperty("外部来源")
    @Query
    private String externalIden;
    /**
     * 外部来源人 精确
     */
    @ApiModelProperty("外部来源人")
    @Query
    private String externalName;
    /**
     * 外部来源电话 精确
     */
    @ApiModelProperty("外部来源电话")
    @Query
    private String externalPhone;
    /**
     * 内部来源BU_ID 精确
     */
    @ApiModelProperty("内部来源BU_ID")
    @Query
    private Long internalBuId;
    /**
     * 利益承诺 精确
     */
    @ApiModelProperty("利益承诺")
    @Query
    private String profitDesc;
    /**
     * 税率 精确
     */
    @ApiModelProperty("税率")
    @Query
    private BigDecimal taxRate;
    /**
     * 销售人员用户ID 精确
     */
    @ApiModelProperty("销售人员用户ID")
    @Query
    private Long saleManUserId;
    /**
     * 内部来源用户ID 精确
     */
    @ApiModelProperty("内部来源用户ID")
    @Query
    private Long internalUserId;
    /**
     * 合同开始日期 精确
     */
    @ApiModelProperty("合同开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Query
    private LocalDate startDate;
    /**
     * 合同结束日期 精确
     */
    @ApiModelProperty("合同结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Query
    private LocalDate endDate;
    /**
     * 纸质合同状态描述 精确
     */
    @ApiModelProperty("纸质合同状态描述")
    @Query
    private String paperDesc;
    /**
     * 纸质合同状态 精确
     */
    @ApiModelProperty("纸质合同状态")
    @Query
    private String paperStatus;
    /**
     * 合同激活时间 精确
     */
    @ApiModelProperty("合同激活时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Query
    private LocalDate acitveDate;
    /**
     * 产品 精确
     */
    @ApiModelProperty("产品")
    @Query
    private Long product;
    /**
     * 简要说明 精确
     */
    @ApiModelProperty("简要说明")
    @Query
    private String briefDesc;
    /**
     * 工作类型 精确
     */
    @ApiModelProperty("工作类型")
    @Query
    private String workType;
    /**
     * 促销类型 精确
     */
    @ApiModelProperty("促销类型")
    @Query
    private String promotionType;
    /**
     * 范围性质 精确
     */
    @ApiModelProperty("范围性质")
    @Query
    private String rangeProp;
    /**
     * 半开口说明 精确
     */
    @ApiModelProperty("半开口说明")
    @Query
    private String halfOpenDesc;
    /**
     * 供应主体类别 精确
     */
    @ApiModelProperty("供应主体类别")
    @Query
    private String supplierType;
    /**
     * 提成类别 精确
     */
    @ApiModelProperty("提成类别")
    @Query
    private String commissionType;
    /**
     * 交易方式 精确
     */
    @ApiModelProperty("交易方式")
    @Query
    private String transactionMethod;
    /**
     * 交易性质 精确
     */
    @ApiModelProperty("交易性质")
    @Query
    private String transactionNature;
    /**
     * 需求类别 精确
     */
    @ApiModelProperty("需求类别")
    @Query
    private String demandType;
    /**
     * 销售分类 精确
     */
    @ApiModelProperty("销售分类")
    @Query
    private String saleClass;
    /**
     * 客户承担差旅费 精确
     */
    @ApiModelProperty("客户承担差旅费")
    @Query
    private String custBarExpense;
    /**
     * 报销政策说明 精确
     */
    @ApiModelProperty("报销政策说明")
    @Query
    private String reimbursementDesc;
    /**
     * 估算当量 精确
     */
    @ApiModelProperty("估算当量")
    @Query
    private BigDecimal ratedEqva;
    /**
     * 估算费用 精确
     */
    @ApiModelProperty("估算费用")
    @Query
    private BigDecimal ratedExpense;
    /**
     * 合同打印方 精确
     */
    @ApiModelProperty("合同打印方")
    @Query
    private String contractPrinter;
    /**
     * 打印份数 精确
     */
    @ApiModelProperty("打印份数")
    @Query
    private Long printCount;
    /**
     * 盖章类型 精确
     */
    @ApiModelProperty("盖章类型")
    @Query
    private String sealType;
    /**
     * 和发票一起邮寄，0：是，1：否 精确
     */
    @ApiModelProperty("和发票一起邮寄，0：是，1：否")
    @Query
    private Integer sendWithInvoiceFlag;
    /**
     * 邮寄地址 模糊
     */
    @ApiModelProperty("邮寄地址")
    @Query(type = Query.Type.INNER_LIKE)
    private String mailingAddress;
    /**
     * 父ID 精确
     */
    @ApiModelProperty("父ID")
    @Query
    private Long parentId;


    /**
     * 签订年度 精确
     */
    @Query
    @ApiModelProperty("签订年度")
    private Long signYear;
    /**
     * 签订日期开始范围 精确
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Query
    @ApiModelProperty("签订日期开始范围")
    private LocalDate signDateStart;
    /**
     * 签订日期结束范围 精确
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Query
    @ApiModelProperty("签订日期结束范围")
    private LocalDate signDateEnd;
    /**
     * 售前bu 精确
     */
    @Query
    @ApiModelProperty("售前bu")
    private Long preSaleBuId;

    /**
     * 售前负责人 精确
     */
    @Query
    @ApiModelProperty("售前负责人")
    private Long preSaleUserId;

    /**
     * 合同金额范围
     */
    @Query
    @ApiModelProperty("合同金额范围")
    private List<BigDecimal> amtScope;

    /**
     * 业绩统计状态
     */
    @ApiModelProperty("业绩统计状态")
    private String achieveStatus;

    /**
     * 业绩统计部门ID
     */
    @ApiModelProperty("业绩统计部门ID")
    private Long achieveBuId;

    /**
     * 价值角色
     */
    @ApiModelProperty("价值角色")
    private String valueRole;

    /**
     * 部门归属人员ID
     */
    @ApiModelProperty("部门归属人员ID")
    private Long chargeResId;
    /**
     * 合同归档标志 0：未归档,1:归档
     */
    @ApiModelProperty("合同归档标志")
    private Integer filingFlag;

    /**
     * 组织id集合，用于列表权限
     */
    private List<Long> orgIdsByPermission;

    /**
     * 用户id集合，用于列表权限
     */
    private List<Long> userIdsByPermission;

    /**
     * 项目是否创建
     */
    private Integer isProjectCreate;

    @ApiModelProperty("额定费用")
    private BigDecimal ratedCost;

    @ApiModelProperty("合同预算是否录入 0-未录入 1-已录入")
    private Integer conConditionFlag;

    @ApiModelProperty("jde同步状态")
    private String jdeStatus;

    @ApiModelProperty("jde失败原因")
    private String jdeFailReason;

}
