package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConContractPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractListVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 销售合同
 *
 * @author danting
 * @date 2023-03-23
 */
public interface SaleConContractService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link SaleConContractVO}>
     */
    PagingVO<SaleConContractVO> paging(SaleConContractQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link SaleConContractVO}>
     */
    PagingVO<SaleConContractVO> queryPaging(SaleConContractQuery query);

    //统计个数
    Long count(SaleConContractQuery query);

    /**
     * 合同权限
     *
     * @param query
     */
    void getPermissionParams(SaleConContractQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link SaleConContractVO}>
     */
    List<SaleConContractVO> queryList(SaleConContractQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link SaleConContractVO}>
     */
    List<SaleConContractVO> queryContractListDynamic(SaleConContractQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link SaleConContractVO}>
     */
    List<SaleConContractListVO> queryListDynamic(SaleConContractQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @param   auth 因为这个接口需要返回合同预算的权限 要获取当前登录人 但是在合同激活流程的第二个节点回调的时候，也调用这个接口 因此加个参数处理
     * @return {@link SaleConContractVO}
     */
    SaleConContractVO queryByKey(Long key,Boolean... auth);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link SaleConContractVO}
     */
    SaleConContractVO insert(SaleConContractPayload payload);


    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link SaleConContractVO}
     */
    SaleConContractVO update(SaleConContractPayload payload);

    /**
     * 动态修改
     *
     * @param payload 单据数据
     * @return {@link SaleConContractVO}
     */
    Long updateByKeyDynamic(SaleConContractPayload payload);

    /**
     * 更新额定信息（额定当量、额定费用）
     *
     * @param payload 单据数据
     * @return {@link SaleConContractVO}
     */
    Long updateInfoByKeyDynamic(SaleConContractPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 激活
     *
     * @param keys 主键集合
     */
    Long active(List<Long> keys);

    /**
     * 暂挂
     *
     * @param keys 主键集合
     */
    Long pending(List<Long> keys);

    /**
     * 关闭
     *
     * @param keys 主键集合
     */
    Long close(List<Long> keys, String closeCacheKey, String authToken);

    /**
     * 作废
     *
     * @param keys 主键集合
     */
    void invalid(List<Long> keys);

    /**
     * 变更
     *
     * @param payload 单据
     */
    void change(SaleConContractPayload payload);

    /**
     * 子合同变更更新
     *
     * @param payload 单据
     */
    void updateChange(SaleConContractPayload payload);

    /**
     * 子合同变更查询
     *
     * @param businessKey key
     */
    SaleConContractVO queryChangeDetail(Long businessKey);
    /**
     * 根据父ID查询子合同集合
     *
     * @param parentId
     * @return
     */
    List<SaleConContractVO> queryListByConId(Long parentId);


    /**
     * 查询日志列表
     *
     * @param key 关键
     * @return {@link List}<{@link PrdSystemLogVO}>
     */
    List<PrdSystemLogVO> queryLogList(Long key);

    /**
     * 生成子合同的名称
     */
    String subCode(Long parentId);

    /**
     * 批量导出活动excel
     *
     * @param response 请求响应
     * @param query    查询条件
     */
    void downloadSaleCon(HttpServletResponse response, SaleConContractQuery query);


    /**
     * 计算子合同开票金额、收款金额、其他应减费用、相关项目采购金额
     *
     * @param conId
     * @return
     */
    Map<String, BigDecimal> amountOfMoney(Long conId);

    /**
     * 用来修改子合同不含税总金额、有效合同金额
     *
     * @param payload
     * @return SaleConContractPayload
     */
    SaleConContractPayload subAmtCount(SaleConContractPayload payload);

    /**
     * 合同归档
     *
     * @param keys
     * @return Long
     */
    Long conFiling(Long[] keys);


    /**
     * 提交虚拟合同
     *
     * @param keys 主键集合
     */
    Long fictitiousConSubmit(List<Long> keys);



    List<PurchaseContractManagerVO> queryPurchConList(Long saleconId);

    /**
     * 无合同入场虚拟合同 激活完成后的动作
     * // 平台合同类型 为 无合同入场虚拟合同（NO_CONTRACT_VIRTUAL_CONTRACT）	 合同状态【待激活】 ，激活流程走完，
     * // 平台合同类型自动改为【平台内合同（INTERNAL）】，
     * // 同步更新对应主合同的平台合同类型为【平台内合同（INTERNAL）】
     *
     * @param id id
     */
    void activeVirtualContractCompleted(Long id);

    /**
     * 通过合同编号查询合同Id
     *
     * @param conNo 合同编号
     * @return 合同Id
     */
    Long findIdByNo(String conNo);


    /**
     * 计算子合同的其他费用
     */
    Map<String, BigDecimal> extraAndDemandTotalAmt(Long conId);

    /**
     * 更新流程
     */
    void updateWorkFlow(SaleConContractVO saleConContractVO);

}
