package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
  * 外包费用确认明细
  *
  * @author likunpeng
  * @date 2023-04-17
  */
@Getter
@Setter
public class ConEpibolyCostConDVO extends BaseViewModel implements Serializable {
    /** 外包费用确认单ID */
    @ApiModelProperty("外包费用确认单ID")
    private Long epibolyCostConId;
    /** 外包费用确认单Code */
    @ApiModelProperty("外包费用确认单Code")
    private String epibolyCostConCode;
    /** 申请人 */
    @ApiModelProperty("申请人Id")
    private Long applyUserId;
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    @ApiModelProperty("申请人Name")
    private String applyUserName;
    /** 申请日期 */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /** 申请BU */
    @ApiModelProperty("申请BU_Id")
    private Long applyBuId;
    @UdcName(udcName = "BU", codePropName = "applyBuId")
    @ApiModelProperty("申请BU_Name")
    private String applyBuName;
    /** 参考合同号 */
    @ApiModelProperty("参考合同号")
    private String referCode;
    /** 销售合同Id */
    @ApiModelProperty("销售合同Id")
    private Long saleConId;
    /** 销售合同名称 */
    @ApiModelProperty("销售合同名称")
    private String saleConName;
    /** 客户Id */
    @ApiModelProperty("客户Id")
    private Long custId;
    /** 客户名称 */
    @ApiModelProperty("客户名称")
    private String custName;
    /** 外包费用备注 */
    @ApiModelProperty("外包费用备注")
    private String mainRemark;
    /** 工作类型 */
    @ApiModelProperty("工作类型")
    private String workType;
    @UdcName(udcName = "con:epiboly_cost:work_type", codePropName = "workType")
    @ApiModelProperty("工作类型Desc")
    private String workTypeDesc;
    /** 具体理由 */
    @ApiModelProperty("具体理由")
    private String reason;
    /** 伙伴类型 */
    @ApiModelProperty("伙伴类型")
    private String partnerType;
    @UdcName(udcName = "con:epiboly_cost:partner_type", codePropName = "partnerType")
    @ApiModelProperty("伙伴类型Desc")
    private String partnerTypeDesc;
    /** 合作方 */
    @ApiModelProperty("合作方")
    private String collaborator;
    /** 基于 */
    @ApiModelProperty("基于")
    private String base;
    @UdcName(udcName = "con:epiboly_cost:base", codePropName = "base")
    @ApiModelProperty("基于Desc")
    private String baseDesc;
    /** 比例 */
    @ApiModelProperty("比例")
    private Integer proportion;
    /** 金额 */
    @ApiModelProperty("金额")
    private BigDecimal amt;
    /** 税费率 */
    @ApiModelProperty("税费率")
    private BigDecimal taxRate;
    @UdcName(udcName = "SYSTEM_BASIC:TAX", codePropName = "taxRate")
    @ApiModelProperty("税费率Desc")
    private String taxRateDesc;
    /** 税费 */
    @ApiModelProperty("税费")
    private BigDecimal taxCost;
    /** 税费承担方 */
    @ApiModelProperty("税费承担方")
    private String taxPayer;
    @UdcName(udcName = "con:epiboly_cost:tax_payer", codePropName = "taxPayer")
    @ApiModelProperty("税费承担方Desc")
    private String taxPayerDesc;
    /** 净支付额 */
    @ApiModelProperty("净支付额")
    private BigDecimal netPay;
    /** 具体支付方式 */
    @ApiModelProperty("具体支付方式")
    private String paymentMethod;
    @UdcName(udcName = "con:epiboly_cost:payment_method", codePropName = "paymentMethod")
    @ApiModelProperty("具体支付方式Desc")
    private String paymentMethodDesc;
    /** 收款节点 */
    @ApiModelProperty("收款节点")
    private String receStage;
    /** 线下合同&沟通签署状态 */
    @ApiModelProperty("线下合同&沟通签署状态")
    private String contractStatus;
    /** 联系人姓名 */
    @ApiModelProperty("联系人姓名")
    private String liaisonName;
    /** 联系电话 */
    @ApiModelProperty("联系电话")
    private String liaisonPhone;
    /** 关联单据类型 */
    @ApiModelProperty("关联单据类型")
    private String docType;
    /** 关联单据号 */
    @ApiModelProperty("关联单据号")
    private String documentNumber;
    /** 明细状态 */
    @ApiModelProperty("明细状态")
    private String detailedStatus;
    @UdcName(udcName = "con:epiboly_cost:status", codePropName = "detailedStatus")
    private String detailedStatusDesc;
    /** 父明细 */
    @ApiModelProperty("父明细")
    private Long parentId;
    /**序号*/
    @ApiModelProperty("序号")
    private String sortNo;
    private Long costCondIdV4;
    /**
     * 关联合同状态
     */
    @ApiModelProperty("关联合同状态")
    private String relatedContractStatus;
    @ApiModelProperty("关联合同状态翻译")
    @UdcName(udcName = "salecon:status", codePropName = "relatedContractStatus")
    private String relatedContractStatusDesc;
    /**
     * 关联合同所关联项目Id
     */
    @ApiModelProperty("关联合同所关联项目Id")
    private Long projId;
    /** 子明细列表 */
    @ApiModelProperty("子明细列表")
    private List<ConEpibolyCostConDVO> childrenList;
}
