package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;
import java.util.List;


/**
 * 采购需求处理
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Getter
@Setter
public class ConPurchaseDemandVO extends BaseViewModel implements Serializable {
    /**
     * 需求编号
     */
    @ApiModelProperty("需求编号")
    private String code;

    /**
     * 需求总金额
     */
    @ApiModelProperty("需求总金额")
    private BigDecimal demandTotalAmt;
    /**
     * 销售合同id
     */
    @ApiModelProperty("销售合同id")
    private Long saleConId;
    /**
     * 销售合同号
     */
    @ApiModelProperty("销售合同号")
    private String saleConCode;
    /**
     * 关联客户id
     */
    @ApiModelProperty("关联客户")
    private Long custId;
    /**
     * 关联客户
     */
    @ApiModelProperty("关联客户")
    private String custName;
    /**
     * 商机id
     */
    @ApiModelProperty("商机id")
    private Long oppoId;
    /**
     * 商机编号
     */
    @ApiModelProperty("商机编号")
    private Long oppoNo;
    /**
     * 需求类别
     */
    @ApiModelProperty("需求类别")
    private String demandType;
    @UdcName(udcName = "salecon:demand_type", codePropName = "demandType")
    private String demandTypeDesc;
    private Long purDemandIdV4;
    /**
     * 需求处理明细
     */
    @ApiModelProperty("需求处理明细")
    private List<ConPurchaseDemandDVO> conPurchaseDemandDVOS;
}
