package com.elitesland.tw.tw5.api.prd.shorturl.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.shorturl.payload.ShortUrlConfPayload;
import com.elitesland.tw.tw5.api.prd.shorturl.query.ShortUrlConfQuery;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlConfVO;

import java.util.List;

/**
 * 短链服务配置
 *
 * @author duwh
 * @date 2023-05-19
 */
public interface ShortUrlConfService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ShortUrlConfVO}>
     */
    PagingVO<ShortUrlConfVO> queryPaging(ShortUrlConfQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ShortUrlConfVO}>
     */
    List<ShortUrlConfVO> queryListDynamic(ShortUrlConfQuery query);

    long count(ShortUrlConfQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ShortUrlConfVO}
     */
    ShortUrlConfVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ShortUrlConfVO}
     */
    ShortUrlConfVO insert(ShortUrlConfPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ShortUrlConfVO}
     */
    ShortUrlConfVO update(ShortUrlConfPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
