package com.elitesland.tw.tw5.api.prd.system.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PrdSystemProblemFeedbackPayload extends TwCommonPayload {

    /**
     * 反馈标题
     */
    @ApiModelProperty("反馈标题")
    private String feedbackTitle;

    /**
     * 问题url
     */
    @ApiModelProperty("问题url")
    private String problemUrl;

    /**
     * 附加
     */
    @ApiModelProperty("附件")
    private String fileCodes;

    /**
     * 反馈状态
     */
    @ApiModelProperty("反馈状态")
    private String feedbackStatus;

    /**
     * 关闭理由
     */
    @ApiModelProperty("关闭理由")
    private String closeReason;

    /**
     * 关闭理由说明
     */
    @ApiModelProperty("关闭理由说明")
    private String closeReasonDesc;

    /**
     * 加急标识，0：不加急，1：加急
     */
    @ApiModelProperty("加急标识，0：不加急，1：加急")
    private Integer urgentFlag;

    /**
     * 回复状态
     */
    @ApiModelProperty("回复状态")
    private String replyStatus;

    /**
     * 内容
     */
    @ApiModelProperty("内容")
    private String content;

    /**
     * 问题类型
     */
    @ApiModelProperty("问题类型")
    private String problemType;

    /**
     * 所属功能
     */
    @ApiModelProperty("所属功能")
    private Long functionId;

    /**
     * 负责人
     */
    @ApiModelProperty("负责人")
    private Long directorUserId;

    /**
     * 阅览量
     */
    @ApiModelProperty("阅览量")
    private Long readAmount;

    /**
     * 标签
     */
    @ApiModelProperty("标签")
    private String tags;

    /**
     * 常用问题标识
     */
    @ApiModelProperty("常用问题标识")
    private Integer commonFlag;

    /**
     * 需要处理的问题ids
     */
    @ApiModelProperty("需要处理的问题ids")
    private List<Long> handleIds;

    /**
     * 严重程度
     */
    @ApiModelProperty("严重程度")
    private String level;
}
