package com.elitesland.tw.tw5.api.prd.adm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 行政订票管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Getter
@Setter
public class AdmTripTicketPayload extends TwCommonPayload implements Serializable {
    /**
     * 申请id
     */
    @ApiModelProperty("申请id")
    private Long applyId;
    /**
     * 订票费用类型
     */
    @ApiModelProperty("订票费用类型")
    private String ticketExpType;
    /**
     * 出差人资源id
     */
    @ApiModelProperty("出差人资源id")
    private Long tripResId;
    /**
     * 订票人资源id
     */
    @ApiModelProperty("订票人资源id")
    private Long bookingResId;
    /**
     * 出发地
     */
    @ApiModelProperty("出发地")
    private String fromPlace;
    /**
     * 目的地
     */
    @ApiModelProperty("目的地")
    private String toPlace;
    /**
     * 交通工具
     */
    @ApiModelProperty("交通工具")
    private String vehicle;
    /**
     * 出差日期
     */
    @ApiModelProperty("出差日期")
    private LocalDate tripDate;
    /**
     * 时间段
     */
    @ApiModelProperty("时间段")
    private String timespan;
    /**
     * 订票日期
     */
    @ApiModelProperty("订票日期")
    private LocalDate bookingDate;
    /**
     * 车次航班
     */
    @ApiModelProperty("车次航班")
    private String vehicleNo;
    /**
     * 金额
     */
    @ApiModelProperty("金额")
    private BigDecimal expAmt;
    /**
     * 票务使用状态
     */
    @ApiModelProperty("票务使用状态")
    private String useStatus;
    /**
     * 购票渠道
     */
    @ApiModelProperty("购票渠道")
    private String ticketPurchasingChannel;
    /**
     * 报销状态
     */
    @ApiModelProperty("报销状态")
    private String reimbursementStatus;
    @ApiModelProperty("报销单id")
    private Long reimId;
}
