package com.elitesland.tw.tw5.api.prd.cal.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 当量成本配置管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Getter
@Setter
public class CalEqvaCostQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 平台编号 精确
     */
    @ApiModelProperty("平台编号")
    private String busifieldType;
    /**
     * buid 精确
     */
    @ApiModelProperty("buid")
    private Long buId;
    /**
     * 当量名称 模糊
     */
    @ApiModelProperty("当量名称")
    private String eqvaName;
    /**
     * 工种 精确
     */
    @ApiModelProperty("工种")
    private String jobType1;
    /**
     * 工种子类 精确
     */
    @ApiModelProperty("工种子类")
    private String jobType2;
    /**
     * 核算年度 精确
     */
    @ApiModelProperty("核算年度")
    private Integer finYear;
    /**
     * 核算期间
     */
    @ApiModelProperty("核算期间")
    private Integer finPeriod;
    /**
     * 当量成本 精确
     */
    @ApiModelProperty("当量成本")
    private BigDecimal eqvaCost;
}
