package com.elitesland.tw.tw5.api.prd.crm.amap.query;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 附近客户筛选
 *
 * @author duwh
 * @date 2023-05-17
 */
@Getter
@Setter
public class AmapTextQuery implements Serializable{

    /**
     * （必填）查询关键字 规则： 多个关键字用“|”分割
     */
    @NotNull
    private String keywords;
    /**
     * 查询城市
     */
    private String city;
    /**
     * 仅返回指定城市数据 可选
     * 可选值：true/false
     * 默认 false
     */
    private Boolean citylimit;

    /**
     * 是否按照层级展示子POI数据
     * 可选值：children=1
     * 当为0的时候，子POI都会显示。
     * 当为1的时候，子POI会归类到父POI之中。
     * 仅在extensions=all的时候生效
     *
     * 默认 0
     */
    private String children;

    /**
     * 查询POI类型  行业
     *
     * 默认 公司企业|知名企业|公司|广告装饰|建筑公司|医药公司|机械电子|冶金化工|网络科技|商业贸易|电信公司|矿产公司|工厂
     */
    private String types;

    /**
     * 每页记录数据 强烈建议不超过25，若超过25可能造成访问报错
     */
    private Integer offset;
    /**
     * 当前页数
     */
    private Integer page;

}
