package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationEnterpriseInfoPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationEnterpriseInfoQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationEnterpriseInfoVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
* 客户经营-企业基本信息
*
* @author duwh
* @date 2022-12-02
*/
public interface CrmCustomerOperationEnterpriseInfoService {

    /**
    * 分页列表
    *
    * @param query 条件
    * @return {@link PagingVO}<{@link CrmCustomerOperationEnterpriseInfoVO}>
    */
    PagingVO<CrmCustomerOperationEnterpriseInfoVO> paging(CrmCustomerOperationEnterpriseInfoQuery query);

    /**
    * 查询列表
    *
    * @param query 条件参数
    * @return {@link List}<{@link CrmCustomerOperationEnterpriseInfoVO}>
    */
    List<CrmCustomerOperationEnterpriseInfoVO> queryList(CrmCustomerOperationEnterpriseInfoQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CrmCustomerOperationEnterpriseInfoVO}
     */
    CrmCustomerOperationEnterpriseInfoVO queryByKey(Long key);

    /**
    * 新增
    *
    * @param payload 单据数据
    * @return {@link CrmCustomerOperationEnterpriseInfoVO}
    */
    CrmCustomerOperationEnterpriseInfoVO insert(CrmCustomerOperationEnterpriseInfoPayload payload);

    /**
    * 修改
    *
    * @param payload 单据数据
    */
    CrmCustomerOperationEnterpriseInfoVO update(CrmCustomerOperationEnterpriseInfoPayload payload);

    /**
    * 逻辑删除
    *
    * @param keys 主键集合
    */
    void deleteSoft(List<Long> keys);

    /**
    * Excel导出数据
    *
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    void download(List<CrmCustomerOperationEnterpriseInfoVO> all, HttpServletResponse response) throws IOException;
}
