package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamGradePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamGradeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamGradeVO;

import javax.servlet.http.HttpServletResponse;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 考核结果等级Service
 */
 
public interface PrdPerformanceExamGradeService {
    
    /**
     * 新增考核结果等级数据
     * @param prdPerformanceExamGradePayload
     * @return
     */
    PrdPerformanceExamGradeVO save(PrdPerformanceExamGradePayload prdPerformanceExamGradePayload);
    
     /**
     * 根据主键更新
     * @param prdPerformanceExamGradePayload
     * @return
     */
    PrdPerformanceExamGradeVO update(PrdPerformanceExamGradePayload prdPerformanceExamGradePayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdPerformanceExamGradeVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdPerformanceExamGradeQuery
     * @return
     */
    PagingVO<PrdPerformanceExamGradeVO> page(PrdPerformanceExamGradeQuery prdPerformanceExamGradeQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
      * 获取列表查询
      * @param prdPerformanceExamGradeQuery
      * @return
      */
     List<PrdPerformanceExamGradeVO> getList(PrdPerformanceExamGradeQuery prdPerformanceExamGradeQuery);
    
        /**
      * 根据条件修改
      * @param prdPerformanceExamGradePayload
      * @return
      */
     Long updateByCondition(PrdPerformanceExamGradePayload prdPerformanceExamGradePayload);

     /**
      * 根据绩效id删除
      * @param id
      * @return
      */
     Long delByExamId(Long id);
 }

