package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-19
 * @desc : 单项能力
 */

@Data
@ApiModel(description = "单项能力")
public class PrdIndividAbilityVO extends BaseViewModel {


    /**
     * 能力名称
     */
    @ApiModelProperty("能力名称")
    private String name;

    /**
     * 编号
     */
    @ApiModelProperty("编号")
    private String docNo;

    /**
     * 是否显示
     */
    @ApiModelProperty("是否显示")
    private Boolean showFlag;

    /**
     * 分类1
     */
    @ApiModelProperty("分类1")
    private String cateType1;
    @UdcName(udcName = "org:employee:ability", codePropName = "cateType1")
    private String cateType1Desc;

    /**
     * 分类2
     */
    @ApiModelProperty("分类2")
    private String cateType2;
    @UdcName(udcName = "org:employee:ability", codePropName = "cateType2")
    private String cateType2Desc;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private Integer state;

    /**
     * 级别id
     */
    @ApiModelProperty("级别id")
    private Long levelId;

    /**
     * 级别名称
     */
    @ApiModelProperty("级别名称")
    private String levelName;

    /**
     * 能力描述
     */
    @ApiModelProperty("能力描述")
    private String abilityDesc;

    /**
     * 级别定义明细
     */
    @ApiModelProperty("级别定义明细")
    private List<PrdAbilityLevelVO> prdAbilityLevelVOList;

    /**
     * 有无级别标志
     */
    @ApiModelProperty("有无级别标志")
    private Boolean levelFlag;

    /**
     * 级别明细名称
     */
    @ApiModelProperty("级别明细名称")
    private String levelDtlName;

    /**
     * 能力级别定义id
     */
    @ApiModelProperty("能力级别定义id")
    private Long abilityLevelId;
}

