package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
* 工时-工作计划
*
* @author duwh
* @date 2022-12-09
*/
@Data
public class TimesheetPlanQuery extends TwQueryParam{
    /** 精确 */
    @Query
    private Long tsUserId;
    /** 精确 */
    @Query
    private String tsStatus;
    /** 精确 */
    @Query
    private String type;
    /** 精确 */
    @Query
    private Long apprUserId;
    /** 精确 */
    @Query
    private Long operPlanId;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String operPlanName;
    /** 精确 */
    @Query
    private Long projId;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String projNo;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String projName;
    /**
     * 事由id
     */
    @Query
    private Long reasonId;
    /**
     * 事由名称
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String reasonName;
    /**
     * 事由类型 01 项目 02 售前 03 bu
     */
    @Query
    private String reasonType;
    /** 任务包id */
    @Query
    private Long taskPackageId;
    /** 任务包编号 冗余 */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskPackageNo;
    /** 任务包名称冗余 */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskPackageName;
    /** 精确 */
    @Query
    private Long taskId;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskNo;
    /** 任务名称 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskName;
    /** 精确 */
    @Query
    private String taskApplyStatus;
    /** 精确 */
    @Query
    private Long actId;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String actName;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String actNo;
    /** 精确 */
    @Query
    private String workType;
    /** 工作内容 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String workDesc;
    /** 工作内容 不为null */
    @Query(type = Query.Type.NOT_NULL, propName = "workDesc")
    private String workDescNotNull;
    /** 精确 */
    @Query(type = Query.Type.BETWEEN)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> weekStartDate;
    /** 精确 */
    @Query
    private Integer yearWeek;
    /** 精确 */
    @Query
    private String apprStatus;
    /** 精确 */
    @Query
    private String settleStatus;
    /** 精确 */
    @Query
    private String apprResult;
    /** 工作时间 BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> workDate;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<BigDecimal> workHour;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> approvalTime;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private List<LocalDate> submitTime;
}
