package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.util.List;

@Data
public class MobAttendanceRuleVO extends BaseViewModel {

    private Long attendanceRuleId;

    /**
     * 规则名称 - T_ATTENDANCE_RULE.RULE_NAME
     */
    private String ruleName;

    /**
     * 规则描述 - T_ATTENDANCE_RULE.RULE_DESC
     */
    private String ruleDesc;

    /**
     * 汇报对象,T_RES.ID,多选用","分割 - T_ATTENDANCE_RULE.REPORT_TO_RES
     */
    private String reportToRes;

    /**
     * 规则类型，UDC（COM:ATTENDANCE_RULE_TYPE） - T_ATTENDANCE_RULE.RULE_TYPE
     */
    private String ruleType;

    /**
     * 超出范围外打卡方式，UDC（COM:ATTENDANCE_OUT_RANGE_RULE） - T_ATTENDANCE_RULE.OUT_RANGE_RULE_WAY
     */
    private String outRangeRuleWay;

    /**
     * 员工打卡时是否必须拍照，UDC（COM:YESNO） - T_ATTENDANCE_RULE.NEED_PHOTO_ATTENDANCE
     */
    private String needPhotoAttendance;

    /**
     * 员工异常打卡时可提交申请，审批通过后修正异常，每月最多补卡，UDC（COM:ATTENDANCE_PATCH_APPLY_LIMIT_COUNT） - T_ATTENDANCE_RULE.ATTENDANCE_PATCH_APPLY_LIMIT_COUNT
     */
    private Integer attendancePatchApplyLimitCount;

    /**
     * 规则生效时间，UDC（COM:ATTENDANCE_RULE_EFFECTIVE_TIME 立即生效、明日生效） - T_ATTENDANCE_RULE.RULE_EFFECTIVE_TIME
     */
    private String ruleEffectiveTime;

    //打卡时间
    @JsonIgnore
    private Boolean attendanceDateMon; //周一是否打卡
    @JsonIgnore
    private Boolean attendanceDateTue; //周二是否打卡
    @JsonIgnore
    private Boolean attendanceDateWed; //周三是否打卡
    @JsonIgnore
    private Boolean attendanceDateThu; //周四是否打卡
    @JsonIgnore
    private Boolean attendanceDateFri; //周五是否打卡
    @JsonIgnore
    private Boolean attendanceDateSat; //周六是否打卡
    @JsonIgnore
    private Boolean attendanceDateSun; //周日是否打卡
    @JsonIgnore
    private String attendanceDateWay;  //是否特殊打卡，UDC（COM:YESNO）

    private Integer todayWeek;  //是否特殊打卡，UDC（COM:YESNO）

    private String attendanceTimeStart;//上班时间
    private String attendanceTimeEnd;  //下班时间
    private String punchLimitStartTime; //在此时间前可打上班卡
    private String punchLimitEndTime;  //在此时间前可打下班卡

    private Boolean todayAttendance;  //今天是否允许打卡


    //打卡规则地址
    private List<MobttendanceSiteVO> sites;

    /**
     * 强制补卡
     */
    private String forceAttendance;
    @UdcName(udcName = "COM:YESNO", codePropName = "forceAttendance")
    private String forceAttendanceName;

    //上班打卡限制时间
    private String punchLimitStartSecondTime;

    // 在此时间后可打下班打卡限制卡
    private String punchLimitEndSecondTime;

    /**
     * 允许迟到时间
     */
    private Long allowLateTimeNum;

    /**
     * 允许早退时间
     */
    private Long allowLeaveTimeNum;

    /**
     * CMS 正常打卡内容说明
     */
    private String cmsContents;

    /**
     * CMS 其他打卡内容说明
     */
    private String cmsOtherContents;
}
