package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 外勤办公申请
 *
 * @author carl
 * @date 2024-05-22
 */
@Getter
@Setter
public class OutWorkApplyVO extends BaseViewModel implements Serializable {
    /**
     * 外出申请人id
     */
    @ApiModelProperty("外出申请人id")
    private Long applyUserId;
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    private String applyUserName;
    /**
     * 归属bu_id
     */
    @ApiModelProperty("归属bu_id")
    private Long orgId;
    @UdcName(udcName = "BU", codePropName = "orgId")
    private String orgName;
    /**
     * base地id
     */
    @ApiModelProperty("base地id")
    private String baseAddrId;
    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "baseAddrId")
    private String baseAddrName;
    /**
     * 直属领导id
     */
    @ApiModelProperty("直属领导id")
    private Long parentUserId;
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    private String parentUserName;
    /**
     * 岗位
     */
    @ApiModelProperty("岗位")
    private String jobs;
    /**
     * 级别
     */
    @ApiModelProperty("级别")
    private String grade;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 外勤办公日期
     */
    @ApiModelProperty("外勤办公日期")
    private LocalDate outWorkDate;
    /**
     * 外勤办公时间开始
     */
    @ApiModelProperty("外勤办公时间开始")
    private LocalDateTime outWorkTimeStart;

    /**
     * 外勤办公时间结束
     */
    @ApiModelProperty("外勤办公时间结束")
    private LocalDateTime outWorkTimeEnd;
    /**
     * 外勤工作天数
     */
    @ApiModelProperty("外勤工作天数")
    private BigDecimal outWorkDays;
    /**
     * 0.5天区分上午下午 AM上午 PM下午
     */
    @ApiModelProperty("0.5天区分上午下午 AM上午 PM下午")
    private String outWorkInterval;
    /**
     * 外勤工作地
     */
    @ApiModelProperty("外勤工作地")
    private String outWorkAddr;
    /**
     * 编号
     */
    @ApiModelProperty("编号")
    private String applyNo;
    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String applyName;
    /**
     * 任务状态
     */
    @ApiModelProperty("任务状态")
    private String applyStatus;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String procInstStatus;
    @UdcName(udcName = "appr_status", codePropName = "procInstStatus")
    private String procInstStatusDesc;
    /**
     * 流程id
     */
    @ApiModelProperty("流程id")
    private String procInstId;
}
