package com.elitesland.tw.tw5.api.prd.my.vo;

import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class TBRAttendanceVO {

    @TwBRFlowField(field = "resId", name = "资源id", type = Long.class, remark = "")
    private Long resId;

    @TwBRFlowField(field = "resNo", name = "资源编号", type = String.class, remark = "")
    private String resNo;

    @TwBRFlowField(field = "resName", name = "资源名称", type = String.class, remark = "")
    private String resName;

    @TwBRFlowField(field = "buName", name = "所属BU名称", type = String.class, remark = "")
    private String buName;

    @TwBRFlowField(field = "attDate", name = "打卡日期", type = LocalDate.class, remark = "")
    private LocalDate attDate;

    @TwBRFlowField(field = "nStart", name = "上班打卡时间", type = String.class, remark = "格式 HH:mm")
    private String nStart;

    @TwBRFlowField(field = "nStartNum", name = "上班打卡时间", type = Long.class, remark = "整数格式，用于计算迟到分钟数")
    private Long nStartNum;

    @TwBRFlowField(field = "nEnd", name = "下班打卡时间", type = String.class, remark = "格式 HH:mm")
    private String nEnd;

    @TwBRFlowField(field = "nEndNum", name = "下班打卡时间", type = Long.class, remark = "整数格式，用于计算早退分钟数")
    private Long nEndNum;

    @TwBRFlowField(field = "nResult", name = "打卡结果", type = String.class, remark = "YESNO")
    private String nResult;

    @TwBRFlowField(field = "nResultDet", name = "正常、迟到或早退、矿工", type = String.class, remark = "")
    private String nResultDet;

    @TwBRFlowField(field = "rStart", name = "规定上班时间", type = String.class, remark = "格式 HH:mm")
    private String rStart;

    @TwBRFlowField(field = "rStartNum", name = "规定上班时间", type = Long.class, remark = "整数格式，用于计算迟到分钟数")
    private Long rStartNum;

    @TwBRFlowField(field = "rEnd", name = "规定下班时间", type = String.class, remark = "格式 HH:mm")
    private String rEnd;

    @TwBRFlowField(field = "rEndNum", name = "规定下班时间", type = Long.class, remark = "整数格式，用于计算早退分钟数")
    private Long rEndNum;

    @TwBRFlowField(field = "ruleType", name = "规则类型", type = String.class, remark = "")
    private String ruleType;

    @TwBRFlowField(field = "allowLateTimeNum", name = "允许迟到分钟数", type = Integer.class, remark = "")
    private Integer allowLateTimeNum;

    @TwBRFlowField(field = "allowLeaveTimeNum", name = "允许早退分钟数", type = Integer.class, remark = "")
    private Integer allowLeaveTimeNum;

    @TwBRFlowField(field = "punchLimitStartTime", name = "在此时间前可打上班卡", type = LocalDateTime.class, remark = "")
    private LocalDateTime punchLimitStartTime;

    @TwBRFlowField(field = "punchLimitEndTime", name = "在此时间前可打下班卡", type = LocalDateTime.class, remark = "")
    private LocalDateTime punchLimitEndTime;
}
