package com.elitesland.tw.tw5.api.prd.partner.common.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;


/**
 * 业务伙伴-账户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BookAccountVO extends BaseViewModel implements Serializable {
    /**
     * 地址薄id
     */
    @ApiModelProperty("地址薄id")
    private Long bookId;

    /**
     * 账户类型 udc[prd:ab:account_type]
     */
    @ApiModelProperty("账户类型 udc[prd:ab:account_type]")
    private String accountType;

    /**
     * 账户类型 udc[prd:ab:account_type]
     */
    @ApiModelProperty("账户类型 udc[prd:ab:account_type]")
    @UdcName(udcName = "prd:ab:account_type", codePropName = "accountType")
    private String accountTypeDesc;

    /**
     * 账户用途 udc[prd:ab:account_usage]
     */
    @ApiModelProperty("账户用途 udc[prd:ab:account_usage]")
    private String accountUsage;

    /**
     * 账户用途 udc[prd:ab:account_usage]
     */
    @ApiModelProperty("账户用途 udc[prd:ab:account_usage]")
    @UdcName(udcName = "prd:ab:account_usage", codePropName = "accountUsage")
    private String accountUsageDesc;

    /**
     * 银行 udc[prd:ab:bank_name]
     */
    @ApiModelProperty("银行 udc[prd:ab:bank_name]")
    private String depositBank;

    /**
     * 银行 udc[prd:ab:bank_name]
     */
    @ApiModelProperty("银行 udc[prd:ab:bank_name]")
    @UdcName(udcName = "prd:ab:bank_name", codePropName = "depositBank")
    private String depositBankDesc;

    /**
     * 开户地
     */
    @ApiModelProperty("开户地")
    private String depositCity;

    /**
     * 开户网点
     */
    @ApiModelProperty("开户网点")
    private String depositBankOutlet;

    /**
     * 户名
     */
    @ApiModelProperty("户名")
    private String accountName;

    /**
     * 账户号
     */
    @ApiModelProperty("账户号")
    private String accountNo;

    /**
     * 币种 udc[SYSTEM_BASIC:CURRENCY]
     */
    @ApiModelProperty("币种 udc[SYSTEM_BASIC:CURRENCY]")
    private String currency;

    /**
     * 币种 udc[SYSTEM_BASIC:CURRENCY]
     */
    @ApiModelProperty("币种 udc[SYSTEM_BASIC:CURRENCY]")
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY", codePropName = "currency")
    private String currencyDesc;

    /**
     * 是否为默认账户
     */
    @ApiModelProperty("是否为默认账户 ")
    private Boolean isDefault;

    /**
     * 内部公司名称
     */
    @ApiModelProperty("内部公司名称 ")
    private String bookName;


    /**
     * 行id
     */
    @ApiModelProperty("行id")
    private String lineId;
}
