package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 内部项目申请
 *
 * @author carl
 * @date 2023-08-23
 */
@Getter
@Setter
public class PmsInnerProjectApplyPayload extends TwCommonPayload implements Serializable {
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;
    /**
     * 项目模板
     */
    @ApiModelProperty("项目模板")
    private Long projTempId;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 签约公司
     */
    @ApiModelProperty("签约公司")
    private Long ouId;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 预计开始日期
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate startDate;
    /**
     * 预计结束日期
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate endDate;
    /**
     * 申请单号
     */
    @ApiModelProperty("申请单号")
    private String applyNo;
    /**
     * 申请状态
     */
    @ApiModelProperty("申请状态")
    private String apprStatus;
    /**
     * 申请人
     */
    @ApiModelProperty("申请人")
    private Long applyResId;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applyDate;
    /**
     * 费用承担bu
     */
    @ApiModelProperty("费用承担bu")
    private Long expenseBuId;
    /**
     * 交付bu
     */
    @ApiModelProperty("交付bu")
    private Long deliBuId;
    /**
     * 交付负责人
     */
    @ApiModelProperty("交付负责人")
    private Long deliResId;
    /**
     * 销售负责人
     */
    @ApiModelProperty("销售负责人")
    private Long salesmanResId;
    /**
     * 项目经理
     */
    @ApiModelProperty("项目经理")
    private Long pmResId;
    /**
     * 预计总人天
     */
    @ApiModelProperty("预计总人天")
    private BigDecimal totalDays;
    /**
     * 预计总当量
     */
    @ApiModelProperty("预计总当量")
    private BigDecimal totalEqva;
    /**
     * 当量预估单价
     */
    @ApiModelProperty("当量预估单价")
    private BigDecimal eqvaPrice;
    /**
     * 费用总预算
     */
    @ApiModelProperty("费用总预算")
    private BigDecimal totalReimbursement;
    /**
     * 预算总成本
     */
    @ApiModelProperty("预算总成本")
    private BigDecimal totalCost;
    /**
     * 删除标志
     */
    @ApiModelProperty("删除标志")
    private Integer delFlag;
    /**
     * 关联项目编号
     */
    @ApiModelProperty("关联项目编号")
    private String relatedProjNo;
    /**
     * 关联项目Id
     */
    @ApiModelProperty("关联项目Id")
    private Long relatedProjId;
    /**
     * 产品编号
     */
    @ApiModelProperty("产品编号")
    private String productNo;
    /**
     * 研发补贴金额
     */
    @ApiModelProperty("研发补贴金额")
    private BigDecimal subsidyAmt;
    /**
     * 折旧月数
     */
    @ApiModelProperty("折旧月数")
    private Integer depreciationMonths;
    /**
     * 折旧开始时间
     */
    @ApiModelProperty("折旧开始时间")
    private LocalDateTime depreciationStartDate;

    @ApiModelProperty("提交标志")
    private Boolean submitFlag = false;

    /**
     * sow节选
     */
    @ApiModelProperty("sow节选")
    private String sowFiles;

    /**
     * 预算附件
     */
    @ApiModelProperty("预算附件")
    private String budgetFiles;

    /**
     * 研发立项附件
     */
    @ApiModelProperty("研发立项附件")
    private String researchFiles;


    /**
     * 流程定义KEY
     */
    private String procDefKey;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;


}
