package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 费用报销税额管理
 *
 * @author sunxw
 * @date 2023-12-05
 */
@Getter
@Setter
public class AccReimTaxPayload extends TwCommonPayload implements Serializable {
    /**
     * 报销单ID
     */
    @ApiModelProperty("报销单ID")
    private Long reimId;
    /**
     * 报销单明细ID
     */
    @ApiModelProperty("报销单明细ID")
    private Long reimDtlId;
    /**
     * 会计科目
     */
    @ApiModelProperty("会计科目")
    private Long finAccSubjId;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
}
