package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.util.List;

/**
 * 报销配置主表
 *
 * @author zoey
 * @date 2024-04-08
 */
@Getter
@Setter
public class AccReimSettingQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 规则名称 模糊 */
    @ApiModelProperty("规则名称")
    private String ruleName;
    /** 状态:1 有效；0 无效 精确 */
    @ApiModelProperty("状态:1 有效；0 无效")
    private Integer effective;
    /** 报销单据类型,udc:ACC:REIM_PROC_KEY 精确 */
    @ApiModelProperty("报销单据类型,udc:ACC:REIM_PROC_KEY")
    private String reimDocType;
    /** 核算项目 精确 */
    @ApiModelProperty("核算项目")
    private String busAccItemId;
    /** 适用公司 精确 */
    @ApiModelProperty("适用公司")
    private String expenseCompany;
    /** 适用范围 精确 */
    @ApiModelProperty("适用范围")
    private String applicationScope;
    /** 适用资源 精确 */
    @ApiModelProperty("适用资源")
    private String applicationSource;
    /** 适用资源 精确 */
    @ApiModelProperty("适用具体用户")
    private Long applicationUser;
    /** 例外人员 精确 */
    @ApiModelProperty("例外人员")
    private String whiteList;
    /** 提醒等级（0警告，1报错） 精确 */
    @ApiModelProperty("提醒等级（0警告，1报错）")
    private Integer remindLevel;
    /** 是否执行规则 0 不执行 1执行 精确 */
    @ApiModelProperty("是否执行规则 0 不执行 1执行")
    private Integer executeFlag;
    /** 是否高亮 0 不高亮 1高亮 精确 */
    @ApiModelProperty("是否高亮 0 不高亮 1高亮")
    private Integer highlightFlag;
    /** 高亮颜色 精确 */
    @ApiModelProperty("高亮颜色")
    private String highlightColor;
    /** 提醒文本 精确 */
    @ApiModelProperty("提醒文本")
    private String remindText;
    /** 报错警告文本 精确 */
    @ApiModelProperty("报错警告文本")
    private String errorText;

    /**
     * 报销配置类型
     */
    @ApiModelProperty("报销配置类型")
    private String reimSettingType;

    /**
     * 具体的报销配置id
     */
    @ApiModelProperty("具体的报销配置id")
    private Long specificReimSettingId;


}
