package com.elitesland.tw.tw5.api.prd.acc.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author sunxw
 * @description 报销记账导出vo
 * @Date 2023/12/6
 */
@Data
public class AccReimExportVO implements Serializable {

    @ApiModelProperty("报销单id")
    private Long id;

    @ApiModelProperty("报销导出批次号，T_ACC_PAY_BATCH.BATCH_NO")
    private String batchNo;

    @ApiModelProperty("会计科目")
    private String finAccSubjCode;

    @ApiModelProperty("会计科目名称")
    private String accName;

    @ApiModelProperty("账号")
    private String accountNo;

    @ApiModelProperty("报销金额(含税)")
    private BigDecimal reimAmt;

    @ApiModelProperty("调整后金额(含税)")
    private BigDecimal adjustAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("子账(即工号")
    private String childAccount;

    @ApiModelProperty("报销说明")
    private String dtlReimRemark;

    @ApiModelProperty("费用承担公司")
    private Long expenseCompany;

    @ApiModelProperty("事由号")
    private Long reasonId;

    @ApiModelProperty("相关项目")
    private String reasonName;

    @ApiModelProperty("报销单号")
    private String reimNo;

    @ApiModelProperty("报销人")
    private String reimName;

    @ApiModelProperty("单据类型")
    private String reimDocType;

    @ApiModelProperty("发票张数")
    private Integer invoiceNum = 0;

    @ApiModelProperty("是否有发票")
    private String invoiceFlag;

    @ApiModelProperty("报销人ORG_ID")
    private Long reimOrgId;

    @ApiModelProperty("报销人ORG名称")
    private String reimOrgName;

    @ApiModelProperty("费用承担部门")
    private Long expenseOrgId;

    @ApiModelProperty("费用承担部门名称")
    private String expenseOrgName;

    @ApiModelProperty("报销说明")
    private String reimRemark;

    @ApiModelProperty("报销人RES_ID")
    private Long reimUserId;

    @ApiModelProperty("费用承担项目")
    private Long expenseProjectId;

    @ApiModelProperty("费用发生日期")
    private LocalDate expenseDate;

    @ApiModelProperty("事由类型")
    private String reasonType;

    @ApiModelProperty("导出人")
    private String exportUserName;

    @ApiModelProperty("导出时间")
    private String exportTime;

    @ApiModelProperty("税额标记 0-否 1-是")
    private Integer taxFlag = 0;

    @ApiModelProperty("核算科目")
    private Long busAccItemId;

    @ApiModelProperty("核算科目名称")
    private String busAccItemName;

    @ApiModelProperty("费用记账日期")
    private LocalDate expenseAccountDate;
}
