package com.elitesland.tw.tw5.api.prd.acc.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;


/**
  * 报销抬头校验
  *
  * @author zoey
  * @date 2024-05-14
  */
@Getter
@Setter
public class AccReimSettingTitleVO extends BaseViewModel implements Serializable {
    /** 发票类型OM:INPUT_INV_TYPE */
    @ApiModelProperty("发票类型INV:INPUT_INV_TYPE")
    private String invType;
    @ApiModelProperty("发票类型Desc")
    @UdcName(udcName = "INV:INPUT_INV_TYPE", codePropName = "invType")
    private String invoiceTypeDesc;
    /** 校验内容（udc） */
    @ApiModelProperty("校验内容（title or title,taxNo）")
    private String checkContent;
    /** 不参与校验发票 */
    @ApiModelProperty("不参与校验发票")
    private String exceptCommodityName;

    /**
     * 配置主表
     */
    private AccReimSettingVO accReimSettingVO;

    /**
     * 不等于
     */
    private Boolean notEqualFlag;
}
