package com.elitesland.tw.tw5.api.prd.cal.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 任务包结算提现单管理
 *
 * @author carl
 * @date 2023-11-15
 */
@Getter
@Setter
@ToString
public class CalTaskSettleWithdrawPayload extends TwCommonPayload implements Serializable {
    /**
     * 提现单id
     */
    @ApiModelProperty("提现单id")
    private Long withdrawId;
    /**
     * 提现单编号
     */
    @ApiModelProperty("提现单编号")
    private String withdrawNo;
    /**
     * 提现资源id
     */
    @ApiModelProperty("提现资源id")
    private Long withdrawResId;
    /**
     * 提现状态：（1：发起提现，2：审批通过）
     */
    @ApiModelProperty("提现状态：（1：发起提现，2：审批通过）")
    private String withdrawStatus;

    /**
     * 提现结算单ids
     */
    @ApiModelProperty("提现结算单ids")
    private List<Long> settleIds;


    /**
     * 提现总当量，校验用
     */
    @ApiModelProperty("提现总当量")
    private BigDecimal withdrawQty;

    /**
     * 提现总金额
     */
    @ApiModelProperty("提现总金额")
    private BigDecimal withdrawAmt;


}
