package com.elitesland.tw.tw5.api.prd.cal.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 当量收入配置变更记录
 *
 * @author wangly
 * @date 2024-02-22
 */
@Getter
@Setter
public class CalEqvaIncomeLogQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 当量收入配置主键 精确
     */
    @ApiModelProperty("当量收入配置主键")
    private Long relateId;
    /**
     * 单位当量收入 精确
     */
    @ApiModelProperty("单位当量收入")
    private BigDecimal preeqvaAmt;
    /**
     * 状态 精确
     */
    @ApiModelProperty("状态")
    private String lineStatus;
    /**
     * 项目id 精确
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 项目名称 精确
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 资源id 精确
     */
    @ApiModelProperty("资源id")
    private Long resId;
    /**
     * 资源类型1内部，0外部 精确
     */
    @ApiModelProperty("资源类型1内部，0外部")
    private String resType;
    /**
     * 版本号 精确
     */
    @ApiModelProperty("版本号")
    private Integer version;
    /**
     * 起始日期 精确
     */
    @ApiModelProperty("起始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;
    /**
     * 失效日期 精确
     */
    @ApiModelProperty("失效日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;
    /**
     * 结算方式 udc[org:employee:withdrawSettleMethod] 精确
     */
    @ApiModelProperty("结算方式 udc[org:employee:withdrawSettleMethod]")
    private String settleType;
}
