package com.elitesland.tw.tw5.api.prd.copartner.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 合伙人绩效自述员工表
 *
 * @author carl
 * @date 2024-06-24
 */
@Getter
@Setter
public class PerformanceReadmeConfigUserPayload extends TwCommonPayload implements Serializable {
    /**
     * 配置主键
     */
    @ApiModelProperty("配置主键")
    private Long configId;
    /**
     * 员工主键
     */
    @ApiModelProperty("员工主键")
    private Long userId;
    /**
     * buid 精确
     */
    @ApiModelProperty("buid")
    private Long buId;
    /**
     * 状态：0未开始或流程中，1已完成
     */
    @ApiModelProperty("状态")
    private Integer applyStatus;
    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String configUserName;
    /**
     * 审批名称
     */
    @ApiModelProperty("审批名称")
    private String procInstName;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String procInstStatus;
    /**
     * 流程id
     */
    @ApiModelProperty("流程id")
    private String procInstId;

    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String configName;

    //是否需要初始化数据
    private Boolean initFlag;
    /**
     * 合伙人绩效自述明细
     */
    @ApiModelProperty("合伙人绩效自述明细")
    private List<PerformanceReadmeUserDetailPayload> performanceReadmeUserDetailPayloads;

}
