package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 商机成单率计算指标详情
 *
 * @author likunpeng
 * @date 2023-11-03
 */
@Getter
@Setter
public class CrmOpportunityMeasureDPayload extends TwCommonPayload  implements Serializable {
    /** 指标类型 */
    @ApiModelProperty("指标类型")
    private String indicatorType;
    /** 计算指标主表id */
    @ApiModelProperty("计算指标主表id")
    private Long measureId;
    /** 字段选项value */
    @ApiModelProperty("字段选项value")
    private String fieldOptionValue;
    /** 字段选项value */
    private String fieldOptionValueDesc;
    /** 数值区间min */
    @ApiModelProperty("数值区间min")
    private BigDecimal numericalValueMin;
    /** 数值区间max */
    @ApiModelProperty("数值区间max")
    private BigDecimal numericalValueMax;
    /** 对应分值 */
    @ApiModelProperty("对应分值")
    private BigDecimal score;
}
