package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdAbilityLevelPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdAbilityLevelQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdAbilityLevelVO;


import javax.servlet.http.HttpServletResponse;


 /**
 * @author : WWW
 * @date : 2023-10-19
 * @desc : 能力级别定义Service
 */
 
public interface PrdAbilityLevelService {
    
    /**
     * 新增能力级别定义数据
     * @param prdAbilityLevelPayload
     * @return
     */
    PrdAbilityLevelVO save(PrdAbilityLevelPayload prdAbilityLevelPayload);
    
     /**
     * 根据主键更新
     * @param prdAbilityLevelPayload
     * @return
     */
    PrdAbilityLevelVO update(PrdAbilityLevelPayload prdAbilityLevelPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdAbilityLevelVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdAbilityLevelQuery
     * @return
     */
    PagingVO<PrdAbilityLevelVO> page(PrdAbilityLevelQuery prdAbilityLevelQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

     /**
      * 获取列表查询
      * @param prdAbilityLevelQuery
      * @return
      */
     List<PrdAbilityLevelVO> getList(PrdAbilityLevelQuery prdAbilityLevelQuery);

     /**
      * 根据能力id删除
      * @param id
      * @return
      */
     Long delByAbilitId(Long id);

     /**
      * 根据能力id 获取级别定义明细
      * @param abilityId
      * @return
      */
     List<PrdAbilityLevelVO> getByAbilityId(Long abilityId);
 }

