package com.elitesland.tw.tw5.api.prd.inv.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 发票主表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Getter
@Setter
public class InvInvoicePayload extends TwCommonPayload implements Serializable {
    /**
     * 发票类型COM:INPUT_INV_TYPE
     */
    @ApiModelProperty("发票类型COM:INPUT_INV_TYPE")
    private String invType;
    /**
     * 发票状态ACC:INV_STATUS
     */
    @ApiModelProperty("发票状态ACC:INV_STATUS")
    private String invState;
    /**
     * 发票报销状态ACC:INV_REIMB_STATUS
     */
    @ApiModelProperty("发票报销状态ACC:INV_REIMB_STATUS")
    private String invReimStatus;
    /**
     * 归属人
     */
    @ApiModelProperty("归属人")
    private Long invOwnerId;
    /**
     * 发票内容根据百望识别的发票内容，例如 餐饮、住宿等，需确认识别方式
     */
    @ApiModelProperty("发票内容根据百望识别的发票内容，例如 餐饮、住宿等，需确认识别方式")
    private String invLtype;
    /**
     * 百望系统发票ID
     */
    @ApiModelProperty("百望系统发票ID")
    private Long baiwangInvId;
    /**
     * 单据主键id:关联的单据主键id
     */
    @ApiModelProperty("单据主键id:关联的单据主键id")
    private Long billId;
    /**
     * 文件主键id:票据信息关联的票据影像文件主键id
     */
    @ApiModelProperty("文件主键id:票据信息关联的票据影像文件主键id")
    private Long fileId;
    /**
     * 是否可抵扣:是否可抵扣，0：否，1：是
     */
    @ApiModelProperty("是否可抵扣:是否可抵扣，0：否，1：是")
    private Integer isDeduct;
    /**
     * 抵扣税额:可抵扣税额
     */
    @ApiModelProperty("抵扣税额:可抵扣税额")
    private BigDecimal deductTax;
    /**
     * 百望发票类型:01-增值税专用发票，02-货物运输业增值税专用发票，03-机动车销售统一发票，04-增值税普通发票，10-增值税电子普通发票，11-增值税普通发票(卷式)，14-增值税电子普通发票（通行费），15-二手车销售统一发票，1002-火车票，1003-飞机票，1004-出租车票，1005-定额发票，1006-客运发票，99-其他发票
     */
    @ApiModelProperty("百望发票类型:01-增值税专用发票，02-货物运输业增值税专用发票，03-机动车销售统一发票，04-增值税普通发票，10-增值税电子普通发票，11-增值税普通发票(卷式)，14-增值税电子普通发票（通行费），15-二手车销售统一发票，1002-火车票，1003-飞机票，1004-出租车票，1005-定额发票，1006-客运发票，99-其他发票")
    private String invoiceType;
    /**
     * 是否删除:是否删除，0-否，1-是
     */
    @ApiModelProperty("是否删除:是否删除，0-否，1-是")
    private Integer isDel;
    /**
     * 有无影像:有无影像，0-无影像，1-有影像
     */
    @ApiModelProperty("有无影像:有无影像，0-无影像，1-有影像")
    private Integer hasPicture;
    /**
     * 有无坐标:有无坐标，0-无，1-有
     */
    @ApiModelProperty("有无坐标:有无坐标，0-无，1-有")
    private Integer hasPosition;
    /**
     * 创建时间:创建时间：yyyy-MM-dd HH:mm:ss
     */
    @ApiModelProperty("创建时间:创建时间：yyyy-MM-dd HH:mm:ss")
    private String baiwangCreateTime;
    /**
     * 修改时间:修改时间：yyyy-MM-dd HH:mm:ss
     */
    @ApiModelProperty("修改时间:修改时间：yyyy-MM-dd HH:mm:ss")
    private String baiwangUpdateTime;
    /**
     * 查验时间:查验时间：yyyy-MM-dd HH:mm:ss
     */
    @ApiModelProperty("查验时间:查验时间：yyyy-MM-dd HH:mm:ss")
    private String inspectionTime;
    /**
     * 查验状态ACC:INV_INSPECTION_STATUS:0-待查验，1-查验一致，2-查无此票，3-不一致，4-查验失败,5-无需查验
     */
    @ApiModelProperty("查验状态ACC:INV_INSPECTION_STATUS:0-待查验，1-查验一致，2-查无此票，3-不一致，4-查验失败,5-无需查验")
    private Integer inspectionStatus;
    /**
     * 查验失败描述:查验失败描述
     */
    @ApiModelProperty("查验失败描述:查验失败描述")
    private String inspectionErrorDesc;
    /**
     * 零税率标识:1:税率栏位显示“免税”， 2:税率栏位显示“不征收”， 3:零税率
     */
    @ApiModelProperty("零税率标识:1:税率栏位显示“免税”， 2:税率栏位显示“不征收”， 3:零税率")
    private Integer zeroTaxRateSign;
    /**
     * 百望发票状态:0：正常, 1：失控, 2：作废, 3：红冲, 4：异常
     */
    @ApiModelProperty("百望发票状态:0：正常, 1：失控, 2：作废, 3：红冲, 4：异常")
    private Integer invoiceState;
    /**
     * 校验状态:票据数据校验状态，0-校验通过，1-校验失败，2-重复发票
     */
    @ApiModelProperty("校验状态:票据数据校验状态，0-校验通过，1-校验失败，2-重复发票")
    private Integer verifyStatus;
    /**
     * 票据报销状态:票据使用状态 ，0-未关联，2-已关联
     */
    @ApiModelProperty("票据报销状态:票据使用状态 ，0-未关联，2-已关联")
    private Integer reimburseStatus;
    /**
     * 归集用途类型:0：普通归集，1：审单归集，2：仅采集
     */
    @ApiModelProperty("归集用途类型:0：普通归集，1：审单归集，2：仅采集")
    private Integer collectUseType;
    /**
     * 创建用户账号、采集人:采集人账号
     */
    @ApiModelProperty("创建用户账号、采集人:采集人账号")
    private String userAccount;
    /**
     * 创建用户id、采集人:采集人id
     */
    @ApiModelProperty("创建用户id、采集人:采集人id")
    private String userId;
    /**
     * 用户名:采集人姓名
     */
    @ApiModelProperty("用户名:采集人姓名")
    private String userName;
    /**
     * 组织机构id:组织结构id
     */
    @ApiModelProperty("组织机构id:组织结构id")
    private String orgId;
    /**
     * 组织机构名称:组织机构名称
     */
    @ApiModelProperty("组织机构名称:组织机构名称")
    private String orgName;
    /**
     * 所属行政区编码:所属行政区编码，增值税通用
     */
    @ApiModelProperty("所属行政区编码:所属行政区编码，增值税通用")
    private String administrativeDivisionNo;
    /**
     * 所属行政区名称:所属行政区名称，增值税通用
     */
    @ApiModelProperty("所属行政区名称:所属行政区名称，增值税通用")
    private String administrativeDivisionName;
    /**
     * 发票代码:发票代码，通用；火车票、行程单无代码，部分其他发票也无代码
     */
    @ApiModelProperty("发票代码:发票代码，通用；火车票、行程单无代码，部分其他发票也无代码")
    private String invoiceCode;
    /**
     * 发票号码:发票号码，通用；火车票为左上角票号，行程单为电子客票号码
     */
    @ApiModelProperty("发票号码:发票号码，通用；火车票为左上角票号，行程单为电子客票号码")
    private String invoiceNo;
    /**
     * 开票日期:开票日期，通用，火车票对应的是乘车日期YYYY-MM-DD
     */
    @ApiModelProperty("开票日期:开票日期，通用，火车票对应的是乘车日期YYYY-MM-DD")
    private String invoiceDate;
    /**
     * 购方名称:购方名称-增值税通用
     */
    @ApiModelProperty("购方名称:购方名称-增值税通用")
    private String purchaserName;
    /**
     * 购方税号:“购方税号，通用；机动车-购方名称及身份证号码/组织机构代码”
     */
    @ApiModelProperty("购方税号:“购方税号，通用；机动车-购方名称及身份证号码/组织机构代码”")
    private String purchaserTaxNo;
    /**
     * 购方开户行账户:购方开户行账户，通用，卷票无
     */
    @ApiModelProperty("购方开户行账户:购方开户行账户，通用，卷票无")
    private String purchaserBank;
    /**
     * 购方地址电话:购方地址电话，通用，卷票无
     */
    @ApiModelProperty("购方地址电话:购方地址电话，通用，卷票无")
    private String purchaserAddressPhone;
    /**
     * 销方名称:销方名称，通用
     */
    @ApiModelProperty("销方名称:销方名称，通用")
    private String saleName;
    /**
     * 销方税号:销方税号，通用
     */
    @ApiModelProperty("销方税号:销方税号，通用")
    private String saleTaxNo;
    /**
     * 销方地址电话:销方地址电话，增值税通用，卷票无
     */
    @ApiModelProperty("销方地址电话:销方地址电话，增值税通用，卷票无")
    private String saleAddressPhone;
    /**
     * 销方开户行账户:销方开户行账户，增值税通用，卷票无
     */
    @ApiModelProperty("销方开户行账户:销方开户行账户，增值税通用，卷票无")
    private String saleBank;
    /**
     * 不含税金额:不含税金额：1.增值税专/普/电：不含税总金额合计；2.机动车：不含税价
     */
    @ApiModelProperty("不含税金额:不含税金额：1.增值税专/普/电：不含税总金额合计；2.机动车：不含税价")
    private BigDecimal totalAmount;
    /**
     * 合计税额:合计税额：1.增值税专/普/电：税额合计；2.机动车：增值税税额；3.行程单：燃油附加费
     */
    @ApiModelProperty("合计税额:合计税额：1.增值税专/普/电：税额合计；2.机动车：增值税税额；3.行程单：燃油附加费")
    private BigDecimal totalTax;
    /**
     * 价税合计:价税合计：1.增值税专/普/电/机动车：价税合计；2.二手车：车价合计；3.卷票：合计金额；4.火车票/出租车/定额/客运发票/其他发票：金额；5.行程单：合计（票价+民航发展基金+燃油附加+其他税费）
     */
    @ApiModelProperty("价税合计:价税合计：1.增值税专/普/电/机动车：价税合计；2.二手车：车价合计；3.卷票：合计金额；4.火车票/出租车/定额/客运发票/其他发票：金额；5.行程单：合计（票价+民航发展基金+燃油附加+其他税费）")
    private BigDecimal amountTax;
    /**
     * 价税合计_中文:价税合计_中文，增值税通用
     */
    @ApiModelProperty("价税合计_中文:价税合计_中文，增值税通用")
    private String amountTaxCn;
    /**
     * 其他税费:其他税费（行程单专有）
     */
    @ApiModelProperty("其他税费:其他税费（行程单专有）")
    private BigDecimal otherTax;
    /**
     * 民航发展基金:民航发展基金（行程单专有）
     */
    @ApiModelProperty("民航发展基金:民航发展基金（行程单专有）")
    private BigDecimal civilAviationFund;
    /**
     * 校验码:校验码，增值税普/电/卷票、行程单含有
     */
    @ApiModelProperty("校验码:校验码，增值税普/电/卷票、行程单含有")
    private String checkCode;
    /**
     * 税控盘号、机器码:税控盘号、机器码，增值税通用
     */
    @ApiModelProperty("税控盘号、机器码:税控盘号、机器码，增值税通用")
    private String machineCode;
    /**
     * 发票密文:增值税专/普/电-密码区，机动车/二手车-税控码
     */
    @ApiModelProperty("发票密文:增值税专/普/电-密码区，机动车/二手车-税控码")
    private String ciphertext;
    /**
     * 备注:发票备注，增值税通用
     */
    @ApiModelProperty("备注:发票备注，增值税通用")
    private String baiwangRemark;
    /**
     * 乘车人:乘车/机人姓名-火车票/行程单/客运发票
     */
    @ApiModelProperty("乘车人:乘车/机人姓名-火车票/行程单/客运发票")
    private String drawer;
    /**
     * 出发地:出发地：火车票、客运发票
     */
    @ApiModelProperty("出发地:出发地：火车票、客运发票")
    private String leaveCity;
    /**
     * 到站地:到达地：火车票、客运发票
     */
    @ApiModelProperty("到站地:到达地：火车票、客运发票")
    private String arriveCity;
    /**
     * 出发时间:出发时间：yyyy-MM-dd HH:mm，火车票的乘车时间，出租车票的上车时间
     */
    @ApiModelProperty("出发时间:出发时间：yyyy-MM-dd HH:mm，火车票的乘车时间，出租车票的上车时间")
    private String leaveTime;
    /**
     * 到站时间:到达时间：yyyy-MM-dd HH:mm，出租车票的下车时间
     */
    @ApiModelProperty("到站时间:到达时间：yyyy-MM-dd HH:mm，出租车票的下车时间")
    private String arriveTime;
    /**
     * 车次:火车票车次
     */
    @ApiModelProperty("车次:火车票车次")
    private String trainNumber;
    /**
     * 座位等级:火车票座位类型
     */
    @ApiModelProperty("座位等级:火车票座位类型")
    private String trainSeat;
    /**
     * 身份证号:身份证号（行程单）
     */
    @ApiModelProperty("身份证号:身份证号（行程单）")
    private String idNum;
    /**
     * 里程:里程（出租车）
     */
    @ApiModelProperty("里程:里程（出租车）")
    private String mileage;
    /**
     * 税率(明细最大最小税率，格式：6%~13%、13%)
     */
    @ApiModelProperty("税率(明细最大最小税率，格式：6%~13%、13%)")
    private String taxRate;
    /**
     * 买方单位代码,个人身份证号
     */
    @ApiModelProperty("买方单位代码,个人身份证号")
    private String buyerIdentification;
    /**
     * 二手车市场税号
     */
    @ApiModelProperty("二手车市场税号")
    private String marketTaxNo;
    /**
     * 卖方单位代码,个人身份证号
     */
    @ApiModelProperty("卖方单位代码,个人身份证号")
    private String sellerId;
    /**
     * 发票在影像中的旋转角度（顺时针）
     */
    @ApiModelProperty("发票在影像中的旋转角度（顺时针）")
    private String orientation;
    /**
     * 是否有公司印章，0：无；1：有
     */
    @ApiModelProperty(" 是否有公司印章，0：无；1：有")
    private String hasSeal;
    /**
     * 车牌号(出租车)
     */
    @ApiModelProperty("车牌号(出租车)")
    private String carNo;
    /**
     * 车架号/车辆识别代码(机动车、二手车)
     */
    @ApiModelProperty("车架号/车辆识别代码(机动车、二手车)")
    private String carCode;
    /**
     * 发动机号码(机动车)
     */
    @ApiModelProperty("发动机号码(机动车)")
    private String carEngineCode;
    /**
     * 机打号码
     */
    @ApiModelProperty("机打号码")
    private String machineInvoiceNo;
    /**
     * 机打代码
     */
    @ApiModelProperty("机打代码")
    private String machineInvoiceCode;
    /**
     * 异步查询码
     */
    @ApiModelProperty("异步查询码")
    private String asyncCode;
    /**
     * 发票坐标对象 该发票在文件中的位置
     */
    @ApiModelProperty("发票坐标对象 该发票在文件中的位置")
    private String invoicePositionX1;
    /**
     * 发票坐标对象 该发票在文件中的位置
     */
    @ApiModelProperty("发票坐标对象 该发票在文件中的位置")
    private String invoicePositionY1;
    /**
     * 发票坐标对象 该发票在文件中的位置
     */
    @ApiModelProperty("发票坐标对象 该发票在文件中的位置")
    private String invoicePositionX2;
    /**
     * 发票坐标对象 该发票在文件中的位置
     */
    @ApiModelProperty("发票坐标对象 该发票在文件中的位置")
    private String invoicePositionY2;
    /**
     * 发票联次
     */
    @ApiModelProperty("发票联次")
    private String invoiceTemplateType;
    /**
     * 发票联次名称
     */
    @ApiModelProperty("发票联次名称")
    private String invoiceTemplateName;
    /**
     * 发票密文
     */
    @ApiModelProperty("发票密文")
    private String invoiceCiphertext;
    /**
     * 主管税务机关代码
     */
    @ApiModelProperty("主管税务机关代码")
    private String taxAuthoritiesCode;
    /**
     * 主管税务机关名称
     */
    @ApiModelProperty("主管税务机关名称")
    private String taxAuthoritiesName;
    /**
     * 厂牌型号
     */
    @ApiModelProperty("厂牌型号")
    private String carModel;
    /**
     * 合格证号
     */
    @ApiModelProperty("合格证号")
    private String certificateNo;
    /**
     * 二手车市场
     */
    @ApiModelProperty("二手车市场")
    private String marketName;
    /**
     * 登记证号
     */
    @ApiModelProperty("登记证号")
    private String registrationNo;
    /**
     * 序列号
     */
    @ApiModelProperty("序列号")
    private String serialNum;
    /**
     * 保险费
     */
    @ApiModelProperty("保险费")
    private BigDecimal premium;
    /**
     * 印刷序号
     */
    @ApiModelProperty("印刷序号")
    private String printNumber;
    /**
     * 开票时间
     */
    @ApiModelProperty("开票时间")
    private String invoiceTime;
    /**
     * 入口
     */
    @ApiModelProperty("入口")
    private String entrance;
    /**
     * 出口
     */
    @ApiModelProperty("出口")
    private String roadExit;
    /**
     * 高速标识
     */
    @ApiModelProperty("高速标识")
    private String isHighway;
    /**
     * 发票明细表ID
     */
    @ApiModelProperty("报销表ID")
    private Long reimId;
    @ApiModelProperty("报销明细表ID")
    private Long reimDId;
    /**
     * 已核销金额
     */
    @ApiModelProperty("已核销金额")
    private BigDecimal writtenOffAmt;
    /**
     * 发票照片
     */
    @ApiModelProperty("发票照片")
    private String imgContent;

    /**
     * 发票凭证
     */
    @ApiModelProperty("JDE批号")
    private String invoiceVoucher;

    /** jde单据公司 */
    @ApiModelProperty("jde单据公司")
    private String jdeCompany;
    /** jde单据号  */
    @ApiModelProperty("jde单据号 ")
    private String jdeDocumentNo;
    /** jde单据类型 */
    @ApiModelProperty("jde单据类型")
    private String jdeDocumentType;
    /** jde付款项 */
    @ApiModelProperty("jde付款项")
    private String jdePaymentItem;
    /** jde发票凭证失败原因 */
    @ApiModelProperty("jde发票凭证失败原因")
    private String jdeInvoiceFailReason;
}
