package com.elitesland.tw.tw5.api.prd.my.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

@Data
@ExcelIgnoreUnannotated
public class UserVacationVO extends BaseViewModel {

    @ApiModelProperty("员工id")
    private Long employeeId;

    @ApiModelProperty("userId")
    private Long userId;
    @UdcName(udcName = "USER", codePropName = "userId")
    @ExcelProperty(value = "姓名", index = 2)
    private String userName;

    @ApiModelProperty("组织")
    private Long orgId;
    @UdcName(udcName = "BU", codePropName = "orgId")
    @ExcelProperty(value = "组织", index = 3)
    private String orgName;

    @ApiModelProperty("员工编号")
    @ExcelProperty(value = "资源编号", index = 1)
    private String employeeNo;

    @ApiModelProperty("年度")
    @ExcelProperty(value = "年度", index = 0)
    private Long vacationYear;

    @ApiModelProperty("假期类型")
    private String vacationType;
    @UdcName(udcName = "org:vacation_type", codePropName = "vacationType")
    @ExcelProperty(value = "假期类型", index = 5)
    private String vacationTypeDesc;

    @ApiModelProperty("开始日期")
    private LocalDate startDate;

    @ExcelProperty(value = "起始日期", index = 6)
    private String startDateStr;

    public String getStartDateStr() {
        if (startDate != null) {
            return startDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return startDateStr;
    }

    @ApiModelProperty("结束日期")
    private LocalDate endDate;

    @ApiModelProperty("截至日期")
    @ExcelProperty(value = "截至日期", index = 7)
    private String endDateStr;

    public String getEndDateStr() {
        if (endDate != null) {
            return endDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return endDateStr;
    }

    @ApiModelProperty("有效期")
    private LocalDate expirationDate;

    @ApiModelProperty("有效期")
    @ExcelProperty(value = "有效期", index = 8)
    private String expirationDateStr;

    public String getExpirationDateStr() {
        if (expirationDate != null) {
            return expirationDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return expirationDateStr;
    }

    @ApiModelProperty("总天数")
    @ExcelProperty(value = "总天数", index = 9)
    private BigDecimal totalDays;

    @ApiModelProperty("当年度天数")
    @ExcelProperty(value = "当年度天数", index = 13)
    private BigDecimal actYearDays;

    @ApiModelProperty("已用天数")
    @ExcelProperty(value = "已用天数", index = 10)
    private BigDecimal usedDays;

    @ApiModelProperty("可用天数")
    @ExcelProperty(value = "可用天数", index = 11)
    private BigDecimal availableDays;

    @ApiModelProperty("未开放天数")
    @ExcelProperty(value = "未开放天数", index = 12)
    private BigDecimal frozenDay;

    @ApiModelProperty("主服务地")
    @ExcelProperty(value = "主服务地", index = 4)
    private String extString5;
    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "extString5")
    private String extString5Name;

    @ApiModelProperty("备注")
    @ExcelProperty(value = "备注", index = 14)
    private String remark;


    @ApiModelProperty("事由类型")
    private String reasonType;

    @ApiModelProperty("事由id")
    private Long reasonId;
}
