package com.elitesland.tw.tw5.api.prd.partner.identity.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 业务伙伴-客户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessCustomerInfoPayload extends TwCommonPayload implements Serializable {
    /**
     * 业务伙伴id business_partner.id
     */
    @ApiModelProperty("业务伙伴id")
    private Long partnerId;

    /**
     * 客户编号
     */
    @ApiModelProperty("客户编号")
    private String customerNo;
    /**
     * 客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]
     */
    @ApiModelProperty("客户状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    private String customerStatus;
    /**
     * 客户级别 udc[crm:customer_grade]
     */
    @ApiModelProperty("客户级别 udc[crm:customer_grade]")
    private String customerGradle;
    /**
     * 客户来源 udc[crm:customer_source]
     */
    @ApiModelProperty("客户来源 udc[crm:customer_source]")
    private String customerSource;
    /**
     * 客户区域 udc[crm:customer_region]
     */
    @ApiModelProperty("客户区域 udc[crm:customer_region]")
    private String customerRegion;
    /**
     * 客户经营状态
     */
    @ApiModelProperty("客户经营状态")
    private Boolean isOperate;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字段4
     */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /**
     * 扩展字段5
     */
    @ApiModelProperty("扩展字段5")
    private String ext5;

    // 经营信息表 的的经营级别
    /**
     * 经营级别 udc[crm:cust_oper:cust_grade]
     */
    @ApiModelProperty("经营级别 udc[crm:cust_oper:cust_grade]")
    private String custGrade;

    /**
     * 策略id business_strategy.id
     */
    @ApiModelProperty("策略id business_strategy.id")
    private Long strategyId;

    /**
     * 分数
     */
    @ApiModelProperty("分数")
    private BigDecimal score;

    /**
     * 指标详情
     */
    @ApiModelProperty("指标详情")
    private String indexInfo;

    /**
     * 客户阶段 udc[crm:customer_stage]
     */
    @ApiModelProperty("客户阶段 udc[crm:customer_stage]")
    private String customerStage;

    //流程字段
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    @ApiModelProperty("流程提交标志")
    private Boolean submit;

    /**
     * 服务负责人
     */
    @ApiModelProperty("服务负责人")
    private Long serviceUserId;

    /**
     * 商务负责人
     */
    @ApiModelProperty("商务负责人")
    private Long businessUserId;

    /**
     * 关怀负责人
     */
    @ApiModelProperty("关怀负责人")
    private Long careUserId;

    /**
     * 运维售后负责人
     */
    @ApiModelProperty("运维售后负责人")
    private Long operationUserId;
    /**
     * 待确认潜在客户
     */
    @ApiModelProperty("待确认潜在客户")
    private Boolean confirmFlag;

    /**
     * 是否同步过JDE
     */
    @ApiModelProperty("是否同步过JDE")
    private Boolean syncJdeFlag;
}
