package com.elitesland.tw.tw5.api.prd.partner.identity.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 业务伙伴-经销商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessDistributorInfoQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 业务伙伴id business_partner.id 精确 */
    @ApiModelProperty("业务伙伴主键 business_partner.id")
    private Long partnerId;
    /** 经销商状态 udc[CRM:BUSINESS_PARTNER:STATUS] 精确 */
    @ApiModelProperty("经销商状态 udc[CRM:BUSINESS_PARTNER:STATUS]")
    private String dealerStatus;
    /** 经销商等级 udc[crm:customer_grade] 精确 */
    @ApiModelProperty("经销商等级 udc[crm:customer_grade]")
    private String dealerGradle;
    /** 授权产品 精确 */
    @ApiModelProperty("授权产品")
    private String authProduct;
    /** 销售区域 精确 */
    @ApiModelProperty("销售区域")
    private String salesArea;
    /** 授权开始时间 精确 */
    @ApiModelProperty("授权开始时间")
    private LocalDate startTime;
    /** 授权结束时间 精确 */
    @ApiModelProperty("授权结束时间")
    private LocalDate endTime;
    /** 授权期间说明 精确 */
    @ApiModelProperty("授权期间说明")
    private String collaborateDescription;
    /** 审核材料附件 精确 */
    @ApiModelProperty("审核材料附件")
    private String fileCodes1;
    /** 实地考察附件 精确 */
    @ApiModelProperty("实地考察附件")
    private String fileCodes2;
    /** 扩展字段1 精确 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 精确 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 精确 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 精确 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 精确 */
    @ApiModelProperty("扩展字段5")
    private String ext5;
}
