package com.elitesland.tw.tw5.api.prd.partner.strategy.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyVO;

import java.util.List;

/**
 * 分级策略
 *
 * @author wangly
 * @date 2023-06-16
 */
public interface BusinessStrategyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessStrategyVO}>
     */
    PagingVO<BusinessStrategyVO> queryPaging(BusinessStrategyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessStrategyVO}>
     */
    List<BusinessStrategyVO> queryListDynamic(BusinessStrategyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessStrategyVO}
     */
    BusinessStrategyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     *
     * */
    void save(BusinessStrategyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessStrategyVO}
     */
    BusinessStrategyVO update(BusinessStrategyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessStrategyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 更新策略状态
     *
     * @param keys 主键集合
     */
    void updateStrategyStatus(List<Long> keys,String strategyStatus);

    /**
     * 业务伙伴分级策略生成客户级别定时任务
     */
    void businessStrategyJobHandler();
}
