package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 资源计划角色明细
 *
 * @author xxb
 * @date 2023-08-11
 */
@Getter
@Setter
public class PmsResourcePlanRoleQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 关联资源计划ID 精确 */
    @ApiModelProperty("关联资源计划ID")
    private Long planId;
    /** 角色 精确 */
    @ApiModelProperty("角色")
    private String role;
    /** 复合能力级别ID 精确 */
    @ApiModelProperty("复合能力级别ID")
    private Long capasetLevelId;
    /** 资源 精确 */
    @ApiModelProperty("资源")
    private Long resId;
    /** 资源状态 精确 */
    @ApiModelProperty("资源状态")
    private String planRoleStatus;
    /** 派发系数 精确 */
    @ApiModelProperty("派发系数")
    private BigDecimal distributeRate;
    /** 开始日期 精确 */
    @ApiModelProperty("开始日期")
    private LocalDate startDate;
    /** 结束日期 精确 */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;
    /** 汇总人天 精确 */
    @ApiModelProperty("汇总人天")
    private BigDecimal totalDays;
    /** 汇总当量 精确 */
    @ApiModelProperty("汇总当量")
    private BigDecimal totalEqva;
    /** 隐藏标志 精确 */
    @ApiModelProperty("隐藏标志")
    private Integer hiddenFlag;

    /** 以下是预留字段 */

//    /** 推荐资源id 精确 */
//    @ApiModelProperty("推荐资源id")
//    private Long recommendResId;
//    /** 读取状态 精确 */
//    @ApiModelProperty("读取状态")
//    private String readStatus;
//    /** 预计日期 精确 */
//    @ApiModelProperty("预计日期")
//    private LocalDate expectedDate;
    /** 关联资源计划ID 精确 */
    @ApiModelProperty("关联资源计划ID")
    private List<Long> planIdList;
}
