package com.elitesland.tw.tw5.api.prd.product.service;

import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductPayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductQuery;
import com.elitesland.tw.tw5.api.prd.product.vo.PrdProductVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * 产品管理
 *
 * @author likunpeng
 * @date 2023-05-22
 */
public interface PrdProductService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdProductVO}>
     */
    PagingVO<PrdProductVO> queryPaging(PrdProductQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdProductVO}>
     */
    List<PrdProductVO> queryListDynamic(PrdProductQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdProductVO}
     */
    PrdProductVO queryByKey(Long key);

    /**
     * 通过主键查询
     *
     * @param keys 主键
     * @return {@link PrdProductVO}
     */
    List<PrdProductVO> queryByKeys(List<Long> keys);
    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdProductVO}
     */
    PrdProductVO insert(PrdProductPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdProductVO}
     */
    PrdProductVO update(PrdProductPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
