package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 外包费用确认明细
 *
 * @author likunpeng
 * @date 2023-04-17
 */
@Getter
@Setter
public class ConEpibolyCostConDPayload extends TwCommonPayload  implements Serializable {
    /** 外包费用确认单ID */
    @ApiModelProperty("外包费用确认单ID")
    private Long epibolyCostConId;
    /** 工作类型 */
    @ApiModelProperty("工作类型")
    private String workType;
    /** 具体理由 */
    @ApiModelProperty("具体理由")
    private String reason;
    /** 伙伴类型 */
    @ApiModelProperty("伙伴类型")
    private String partnerType;
    /** 合作方 */
    @ApiModelProperty("合作方")
    private String collaborator;
    /** 基于 */
    @ApiModelProperty("基于")
    private String base;
    /** 比例 */
    @ApiModelProperty("比例")
    private Integer proportion;
    /** 金额 */
    @ApiModelProperty("金额")
    private BigDecimal amt;
    /** 税费率 */
    @ApiModelProperty("税费率")
    private BigDecimal taxRate;
    /** 税费 */
    @ApiModelProperty("税费")
    private BigDecimal taxCost;
    /** 税费承担方 */
    @ApiModelProperty("税费承担方")
    private String taxPayer;
    /** 净支付额 */
    @ApiModelProperty("净支付额")
    private BigDecimal netPay;
    /** 具体支付方式 */
    @ApiModelProperty("具体支付方式")
    private String paymentMethod;
    /** 收款节点 */
    @ApiModelProperty("收款节点")
    private String receStage;
    /** 线下合同&沟通签署状态 */
    @ApiModelProperty("线下合同&沟通签署状态")
    private String contractStatus;
    /** 联系人姓名 */
    @ApiModelProperty("联系人姓名")
    private String liaisonName;
    /** 联系电话 */
    @ApiModelProperty("联系电话")
    private String liaisonPhone;
    /** 关联单据类型 */
    @ApiModelProperty("关联单据类型")
    private String docType;
    /** 关联单据号 */
    @ApiModelProperty("关联单据号")
    private String documentNumber;
    /** 明细状态 */
    @ApiModelProperty("明细状态")
    private String detailedStatus;
    /** 父明细 */
    @ApiModelProperty("父明细")
    private Long parentId;

    @ApiModelProperty("流程提交标志")
    private Boolean submit;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    private Long costCondIdV4;
}
