package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 合同开票批次
 *
 * @author likunpeng
 * @date 2023-07-19
 */
public interface ConInvBatchService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConInvBatchVO}>
     */
    PagingVO<ConInvBatchVO> queryPaging(ConInvBatchQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConInvBatchVO}>
     */
    List<ConInvBatchVO> queryListDynamic(ConInvBatchQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConInvBatchVO}
     */
    ConInvBatchVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConInvBatchVO}
     */
    ConInvBatchVO insert(ConInvBatchPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConInvBatchVO}
     */
    ConInvBatchVO update(ConInvBatchPayload payload);


    /**
     * 更新自动开票状态
     *
     * @param payload 单据数据
     * @return {@link ConInvBatchVO}
     */
    void updateInvFlag(ConInvBatchPayload payload);


    /**
     * 发起流程
     *
     * @param key 单据数据
     */
    void submitProc(Long key);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(ConInvBatchPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据批次号查询该批次的合同收款计划列表
     *
     * @param key
     * @return
     */
    List<ConReceivablePlanVO> queryRecvplanList(Long key);

    /**
     * 退票
     *
     * @param invBatchId
     * @param disDisc
     */
    void returnTicket(Long invBatchId, String disDisc);

    /**
     * 根据客户id查询历史开票记录，且主合同一致的放最前面
     *
     * @param custId
     * @param contractId
     * @return
     */
    List<ConInvBatchVO> getHistoryInv(Long custId, Long contractId);

    /**
     * 完成开票
     *
     * @param payload
     * @return
     */
    int completeInvBatch(ConInvBatchPayload payload);

    /**
     * 发送单据信息 至 百望
     *
     * @param invId
     */
    void outputInvoiceInBaiwang(Long invId, Integer invOrRefund);

    /**
     * 发送单据信息 至 百望
     *
     * @param invId
     */
    void sendInvInfoToBaiwang(Long invId, Integer invOrRefund);

    /**
     * 删除百望流水单
     *
     * @param valueOf
     */
    void deleteInvInfoToBaiwang(Long valueOf, Integer invOrRefund);

    /**
     * 从百望获取发票信息
     *
     * @return
     */
    int getInvoicesFromBaiwang();


    /**
     * 批量导出
     *
     * @param response
     * @param query
     */
    void downloadBatch(HttpServletResponse response, ConInvBatchQuery query);

    /**
     * 开票退回功能
     *
     * @param ids
     * @return
     */
    String reject(Long[] ids);

    /**
     * 同步合同开票数据到4.0
     *
     * @param param
     */
    @Deprecated
    void syncContractInvBatchTo4(String param);

    /**
     * 同步合同开票发票数据到4.0
     *
     * @param param
     */
    @Deprecated
    void syncContractInvBatchInvDtlTo4(String param);

    /**
     * 发送邮件
     *
     * @param conInvBatchVO
     */
    void sendEmail(ConInvBatchVO conInvBatchVO);

    /**
     * 更新发票批次单据的状态
     *
     * @param id
     * @param batchStatus
     */
    Long updateBatchStatusById(Long id, String batchStatus);
}
