package com.elitesland.tw.tw5.api.prd.system.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 系统快捷入口
 *
 * @author wangly
 * @date 2024-03-28
 */
@Getter
@Setter
public class PrdSystemShortcutPayload extends TwCommonPayload implements Serializable {
    /**
     * 快捷入口名称
     */
    @ApiModelProperty("快捷入口名称")
    private String shortcutName;
    /**
     * 快捷入口前端路由
     */
    @ApiModelProperty("快捷入口前端路由")
    private String portalRoute;
    /**
     * 快捷入口图标
     */
    @ApiModelProperty("快捷入口图标")
    private String shortcutIcon;
    /**
     * 快捷入口排序
     */
    @ApiModelProperty("快捷入口排序")
    private Integer sortIndex;
    /**
     * 快捷入口状态
     */
    @ApiModelProperty("快捷入口状态 快捷入口状态 1是 0否")
    private Integer shortcutStatus;
    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String type;
    /**
     * web类型 pc app
     */
    @ApiModelProperty("web类型 pc app")
    private String webType;
    /**
     * 是否固定(固定后app页面不能移动)
     */
    @ApiModelProperty("是否固定(固定后app页面不能移动)")
    private Boolean fixFlag;
}
