package com.elitesland.tw.tw5.api.prd.system.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;


/**
  * 公共地点表
  *
  * @author zoey
  * @date 2024-04-22
  */
@Getter
@Setter
public class PrdSystemSiteVO extends BaseViewModel implements Serializable {
    /** 地点名称 */
    @ApiModelProperty("地点名称")
    private String siteDesc;
    /** 经度 */
    @ApiModelProperty("经度")
    private String siteLongitude;
    /** 纬度 */
    @ApiModelProperty("纬度")
    private String siteLatitude;

    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;

    /**
     * 最后更新人
     */
    @ApiModelProperty("最后更新人")
    @UdcName(udcName = "USER", codePropName = "modifyUserId")
    private String modifyUserName;

    /** 关系表ID */
    @Comment("关系表ID")
    @Column()
    private Long refId;

}
