package com.elitesland.tw.tw5.api.prd.cal.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 当量结算定价管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Getter
@Setter
public class CalSettlePricePayload extends TwCommonPayload implements Serializable {
    /**
     * from bu结算类型码
     */
    @ApiModelProperty("from bu结算类型码")
    private String fromBuDealtype;
    /**
     * to bu结算类型码
     */
    @ApiModelProperty("to bu结算类型码")
    private String toBuDealtype;
    /**
     * from bu_id
     */
    @ApiModelProperty("from bu_id")
    private Long fromBuId;
    /**
     * to bu_id
     */
    @ApiModelProperty("to bu_id")
    private Long toBuId;
    /**
     * 工种
     */
    @ApiModelProperty("工种")
    private String jobType1;
    /**
     * 工种子类
     */
    @ApiModelProperty("工种子类")
    private String jobType2;
    /**
     * 核算年度
     */
    @ApiModelProperty("核算年度")
    private Integer finYear;
    /**
     * 核算期间
     */
    @ApiModelProperty("核算期间")
    private Integer finPeriod;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projName;
    /**
     * 资源id
     */
    @ApiModelProperty("资源id")
    private Long resId;
    /**
     * 定价策略（mark up百分比，mark up金额，绝对结算金额）
     */
    @ApiModelProperty("定价策略（mark up百分比，mark up金额，绝对结算金额）")
    private String priceStrategy;
    /**
     * 调整价格（mark up百分比，mark up金额，绝对结算金额）
     */
    @ApiModelProperty("调整价格（mark up百分比，mark up金额，绝对结算金额）")
    private BigDecimal markupPrice;
}
