package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TaskAuthorizedDetailsPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TaskAuthorizedDetailsQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskAuthorizedDetailsVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 任务包授权主表
 *
 * @author duwh
 * @date 2022-12-16
 */
public interface TaskAuthorizedDetailsService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TaskAuthorizedDetailsVO}>
     */
    PagingVO<TaskAuthorizedDetailsVO> paging(TaskAuthorizedDetailsQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TaskAuthorizedDetailsVO}>
     */
    List<TaskAuthorizedDetailsVO> queryList(TaskAuthorizedDetailsQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TaskAuthorizedDetailsVO}
     */
    TaskAuthorizedDetailsVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TaskAuthorizedDetailsVO}
     */
    TaskAuthorizedDetailsVO insert(TaskAuthorizedDetailsPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TaskAuthorizedDetailsVO}
     */
    TaskAuthorizedDetailsVO update(TaskAuthorizedDetailsPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * Excel导出数据
     *
     * @param all      待导出的数据
     * @param response /
     * @throws IOException /
     */
    void download(List<TaskAuthorizedDetailsVO> all, HttpServletResponse response) throws IOException;
}
