package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.List;

/**
 * 采购协议
 *
 * @author Echo
 * @date 2023-06-08
 */
@Getter
@Setter
public class PurchaseAgreementPayload extends TwCommonPayload  implements Serializable {
    /** 采购协议编号 */
    @ApiModelProperty("采购协议编号")
    private String purchaseAgreementNo;
    /** 采购协议名称 */
    @ApiModelProperty("采购协议名称")
    private String purchaseAgreementName;
    /** 协议类型 */
    @ApiModelProperty("协议类型]")
    private String agreementType;
    /** 验收方式 */
    @ApiModelProperty("验收方式")
    private String acceptanceType;
    /** 签约日期 */
    @ApiModelProperty("签约日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDate;
    /** 申请日期 */
    @ApiModelProperty("申请日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applicationDate;
    /** 签约公司地址簿Id */
    @ApiModelProperty("签约公司地址簿Id")
    private Long signCompanyBookId;
    /** 签约BU */
    @ApiModelProperty("签约BU")
    private Long signBuId;
    /** 签约负责人 */
    @ApiModelProperty("签约负责人")
    private Long signInchargeResId;
    /** 供应商地址簿ID */
    @ApiModelProperty("供应商地址簿ID")
    private Long supplierBookId;
    /** 币种  */
    @ApiModelProperty("币种")
    private String currCode;
    /** 金额 */
    @ApiModelProperty("金额")
    private BigDecimal amt;
    /** 税率 */
    @ApiModelProperty("税率")
    private String taxRate;
    /** 税额 */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /** 协议内容说明 */
    @ApiModelProperty("协议内容说明")
    private String agreementContentDescription;
    /** 比价资料 */
    @ApiModelProperty("比价资料")
    private String pricecompereFileCodes;
    /** 协议附件 */
    @ApiModelProperty("协议附件")
    private String agreementFileCodes;
    /** 盖章附件 */
    @ApiModelProperty("盖章附件")
    private String stampFileCodes;
    /** 开票方 */
    @ApiModelProperty("开票方")
    private Long invoice;
    /** 付款方式 */
    @ApiModelProperty("付款方式")
    private String payMethod;
    /** 协议状态 */
    @ApiModelProperty("协议状态")
    private String agreementStatus;
    /** 协议归属编号 */
    @ApiModelProperty("协议归属编号")
    private String agreementOwnershipNo;
    /** 激活时间 */
    @ApiModelProperty("激活时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDateTime activateDate;
    /** 前置单据负责人 */
    @ApiModelProperty("前置单据负责人")
    private Long preReceiptResId;
    /** 终止原因 */
    @ApiModelProperty("终止原因")
    private String overReason;
    /** 终止日期 */
    @ApiModelProperty("终止日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDateTime overDate;

    /**
     * 有效开始日期
     */
    @ApiModelProperty("有效开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate effectiveStartDate;
    /**
     * 有效结束日期
     */
    @ApiModelProperty("有效结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate effectiveEndDate;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /** 采购明细 */
    @ApiModelProperty("采购明细")
    private List<PurchaseAgreementDetailsPayload> details;
}
