package com.elitesland.tw.tw5.api.prd.ts.service;

import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsApprovalResQuery;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalResVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 工时审批资源管理
 *
 * @author carl
 * @date 2024-05-04
 */
public interface TsApprovalResService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TsApprovalResVO}>
     */
    PagingVO<TsApprovalResVO> queryPaging(TsApprovalResQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TsApprovalResVO}>
     */
    List<TsApprovalResVO> queryListDynamic(TsApprovalResQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TsApprovalResVO}
     */
    TsApprovalResVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TsApprovalResVO}
     */
    TsApprovalResVO insert(TsApprovalResPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TsApprovalResVO}
     */
    TsApprovalResVO update(TsApprovalResPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TsApprovalResPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 逻辑删除
     *
     * @param timesheetId 工时列表
     */
    void deleteSoftByTimesheetId(Long timesheetId);

}
