package com.elitesland.tw.tw5.api.prd.borrow.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.List;


/**
 * 借款管理
 *
 * @author wangly
 * @date 2024-07-15
 */
@Getter
@Setter
public class BorrowMoneyVO extends BaseViewModel implements Serializable {
    /**
     * 借款编号
     */
    @ApiModelProperty("借款编号")
    private String borrowNo;
    /**
     * 借款名称
     */
    @ApiModelProperty("借款名称")
    private String borrowName;
    /**
     * 申请人
     */
    @ApiModelProperty("申请人")
    private Long applicantUserId;
    /**
     * 申请人
     */
    @ApiModelProperty("申请人")
    @UdcName(udcName = "USER", codePropName = "applicantUserId")
    private String applicantUserName;
    /**
     * 出让日期
     */
    @ApiModelProperty("出让日期")
    private LocalDate transferDate;
    /**
     * 受让人ID
     */
    @ApiModelProperty("受让人ID")
    private Long receiveUserId;
    /**
     * 申请人
     */
    @ApiModelProperty("受让人ID")
    @UdcName(udcName = "USER", codePropName = "receiveUserId")
    private String receiveUserName;
    /**
     * 受让人所属bu
     */
    @ApiModelProperty("受让人所属bu")
    private Long receiveBuId;
    /**
     * 受让人所属bu
     */
    @ApiModelProperty("受让人所属bu")
    @UdcName(udcName = "BU", codePropName = "receiveBuId")
    private String receiveBuName;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applicantTime;
    /**
     * 申请人所属bu
     */
    @ApiModelProperty("申请人所属bu")
    private Long applicantBuId;
    /**
     * 申请人所属bu
     */
    @ApiModelProperty("申请人所属bu")
    @UdcName(udcName = "BU", codePropName = "applicantBuId")
    private String applicantBuName;
    /**
     * 单据状态 udc[BORROW_MONEY:STATUS]
     */
    @ApiModelProperty("单据状态 udc[BORROW_MONEY:STATUS]")
    private String apprStatus;

    /**
     * 单据状态 udc[BORROW_MONEY:STATUS]
     */
    @ApiModelProperty("单据状态 udc[BORROW_MONEY:STATUS]")
    @UdcName(udcName = "BORROW_MONEY:STATUS", codePropName = "apprStatus")
    private String apprStatusDesc;
    /**
     * 业务类型 udc[BORROW_MONEY:BUSINESS_TYPE]
     */
    @ApiModelProperty("业务类型 udc[BORROW_MONEY:BUSINESS_TYPE]")
    private String businessType;
    /**
     * 业务类型 udc[BORROW_MONEY:BUSINESS_TYPE]
     */
    @ApiModelProperty("业务类型 udc[BORROW_MONEY:BUSINESS_TYPE]")
    @UdcName(udcName = "BORROW_MONEY:BUSINESS_TYPE", codePropName = "businessType")
    private String businessTypeDesc;
    /**
     * 是否出让
     */
    @ApiModelProperty("是否出让")
    private Boolean transferFlag;
    /** 还款人ID */
    @ApiModelProperty("还款人ID")
    private Long repaymentUserId;
    /**
     * 借款金额
     */
    @ApiModelProperty("借款金额")
    private BigDecimal borrowAmt;
    /**
     * 已核销金额
     */
    @ApiModelProperty("已核销金额")
    private BigDecimal alreadyWriteOffAmt;
    /**
     * 未核销金额
     */
    @ApiModelProperty("未核销金额")
    private BigDecimal unwriteOffAmt;
    /**
     * 预计核销日期
     */
    @ApiModelProperty("预计核销日期")
    private LocalDate preWriteOffDate;
    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private String fileCodes;

    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private Object fileData;
    /**
     * 收款账户
     */
    @ApiModelProperty("收款账户")
    private String accountNo;
    /**
     * 户名
     */
    @ApiModelProperty("户名")
    private String holderName;
    /**
     * 收款银行
     */
    @ApiModelProperty("收款银行")
    private String bankName;
    /**
     * 扩展字段1
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字4
     */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /**
     * 扩展字5
     */
    @ApiModelProperty("扩展字5")
    private String ext5;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("流程审批状态")
    @UdcName(udcName = "appr_status",codePropName = "procInstStatus")
    private String procInstStatusDesc;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /**
     * 出让申请列表
     */
    @ApiModelProperty("出让申请列表")
    private List<TransferApplyVO> transferApplyList;

    /**
     * 借款核销列表
     */
    @ApiModelProperty("借款核销列表")
    private List<BorrowWriteOffVO> borrowWriteOffList;

    /**
     * 申请人所在三级部门负责人
     */
    @ApiModelProperty("申请人所在三级部门负责人")
    private Long level3BuManagerId = 0L;

    /**
     * 申请人所在二级部门负责人
     */
    @ApiModelProperty("申请人所在二级部门负责人")
    private Long level2BuManagerId = 0L;

    /**
     * 申请人所在一级部门负责人
     */
    @ApiModelProperty("申请人所在一级部门负责人")
    private Long level1BuManagerId = 0L;
    /**
     * 本次核销金额
     */
    @ApiModelProperty("本次核销金额")
    private BigDecimal writeOffAmt;
}
