package com.elitesland.tw.tw5.api.prd.copartner.query;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 合伙人绩效自述表
 *
 * @author carl
 * @date 2024-06-24
 */
@Getter
@Setter
public class PerformanceReadmeUserDetailQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * 配置主键 精确
     */
    @ApiModelProperty("配置主键")
    private Long configId;
    /**
     * 配置详情主键 精确
     */
    @ApiModelProperty("配置详情主键")
    private Long configDetailId;
    /**
     * 员工详情主键
     */
    @Comment("员工详情主键")
    @Column()
    private Long configUserId;
    /**
     * 员工主键 精确
     */
    @ApiModelProperty("员工主键")
    private Long userId;

    /**
     * 合同id 精确
     */
    @ApiModelProperty("合同id")
    private Long contractId;
    /**
     * 合同名称 模糊
     */
    @ApiModelProperty("合同名称")
    private String contractName;
    /**
     * 合同类型 精确
     */
    @ApiModelProperty("合同类型")
    private String contractType;
    /**
     * 商机id 精确
     */
    @ApiModelProperty("商机id")
    private Long oppoId;
    /**
     * 商机名称 模糊
     */
    @ApiModelProperty("商机名称")
    private String oppoName;
    /**
     * 业务种类 精确
     */
    @ApiModelProperty("业务种类")
    private String businessType;
    /**
     * 签单金额 精确
     */
    @ApiModelProperty("签单金额")
    private BigDecimal amount;
    /**
     * 签单金额（不含税） 精确
     */
    @ApiModelProperty("签单金额（不含税）")
    private BigDecimal amountNoTax;
    /**
     * 签单销售人员id 精确
     */
    @ApiModelProperty("签单销售人员id")
    private Long saleUserId;
    /**
     * 工时总人天 精确
     */
    @ApiModelProperty("工时总人天")
    private BigDecimal totalDays;
    /**
     * 工时售前人天 精确
     */
    @ApiModelProperty("工时售前人天")
    private BigDecimal preSaleDays;
    /**
     * 售前支持角色 精确
     */
    @ApiModelProperty("售前支持角色")
    private String preSaleRole;
    /**
     * 工时商务人天 精确
     */
    @ApiModelProperty("工时商务人天")
    private BigDecimal businessDays;
    /**
     * 商务支持角色 精确
     */
    @ApiModelProperty("商务支持角色")
    private String businessRole;
    /**
     * 工时交付人天 精确
     */
    @ApiModelProperty("工时交付人天")
    private BigDecimal deliDays;
    /**
     * 交付支持角色 精确
     */
    @ApiModelProperty("交付支持角色")
    private String deliRole;
    /**
     * 自动还是手动创建0:自动，1：手动
     */
    @ApiModelProperty("自动还是手动创建")
    private Integer createFlag;
    /**
     * 拓展字符串1 精确
     */
    @ApiModelProperty("拓展字符串1")
    private String extStr1;
    /**
     * 拓展字符串2 精确
     */
    @ApiModelProperty("拓展字符串2")
    private String extStr2;
    /**
     * 拓展字符串3 精确
     */
    @ApiModelProperty("拓展字符串3")
    private String extStr3;
    /**
     * 拓展字符串4 精确
     */
    @ApiModelProperty("拓展字符串4")
    private String extStr4;
    /**
     * 拓展字符串5 精确
     */
    @ApiModelProperty("拓展字符串5")
    private String extStr5;
    /**
     * 拓展数字1 精确
     */
    @ApiModelProperty("拓展数字1")
    private BigDecimal extNumber1;
    /**
     * 拓展数字2 精确
     */
    @ApiModelProperty("拓展数字2")
    private BigDecimal extNumber2;
    /**
     * 拓展数字3 精确
     */
    @ApiModelProperty("拓展数字3")
    private BigDecimal extNumber3;
    /**
     * 拓展主键1 精确
     */
    @ApiModelProperty("拓展主键1")
    private Long extKey1;
    /**
     * 拓展主键2 精确
     */
    @ApiModelProperty("拓展主键2")
    private Long extKey2;
    /**
     * 拓展主键3 精确
     */
    @ApiModelProperty("拓展主键3")
    private Long extKey3;
}
